#!/bin/sh
# -*- coding: utf-8 -*-
'''which' python3 2> /dev/null && exec python3 "$0" "$@" || which python2 2> /dev/null && exec python2 "$0" "$@" || exec python "$0" "$@"
'''
from __future__ import print_function, unicode_literals
version = '1.1d'
import subprocess
import sys
import_error = []
try:
    import dbus
except ImportError:
    if sys.version_info.major == 3:
        import_error.append('No D-Bus support detected. Please install dbus-python first.')
    else:
        import_error.append('No D-Bus support detected. (And could not find Python3.) Please install dbus-python.')
import re
import os
import uuid
import getpass
from random import SystemRandom as random
from string import ascii_lowercase, digits
from base64 import b64decode
from webbrowser import open as url_open
from threading import Thread
import_error = []
try:
    from json import loads as json_decode
except ImportError:
    import_error.append('No JSON support detected.')
try:
    import http.client as http_lib
    from urllib.parse import urlparse
except:
    import httplib as http_lib
    from urlparse import urlparse
try:
    from ssl import create_default_context as tls, SSLError
except ImportError:
    import_error.append('No TLS support detected.')
    import_error.append('Python >2.7.9/>3.4.0 is needed.')
from os import environ as env
from time import sleep
class DevApi(object):
    DEPLOYSTATE_OK = 1
    CHECK_HOST = 'wtc.tu-chemnitz.de'
    IDM_HOST = 'idm.hrz.tu-chemnitz.de'
    PHASE1_URI = '/user/service/account/devicepasswords/api-integration/%s/'
    PHASE2_URI = '/user/service/account/devicepasswords/api-integration/poll/%s/%s/'
    DEPLOY_TRIES = 30
    DEPLOY_WAIT = 3
    ISRG_ROOT_X1_CERT = b64decode('''MIIFazCCA1OgAwIBAgIRAIIQz7DSQONZRGPgu2OCiwAwDQYJKoZIhvcNAQELBQAw
TzELMAkGA1UEBhMCVVMxKTAnBgNVBAoTIEludGVybmV0IFNlY3VyaXR5IFJlc2Vh
cmNoIEdyb3VwMRUwEwYDVQQDEwxJU1JHIFJvb3QgWDEwHhcNMTUwNjA0MTEwNDM4
WhcNMzUwNjA0MTEwNDM4WjBPMQswCQYDVQQGEwJVUzEpMCcGA1UEChMgSW50ZXJu
ZXQgU2VjdXJpdHkgUmVzZWFyY2ggR3JvdXAxFTATBgNVBAMTDElTUkcgUm9vdCBY
MTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAK3oJHP0FDfzm54rVygc
h77ct984kIxuPOZXoHj3dcKi/vVqbvYATyjb3miGbESTtrFj/RQSa78f0uoxmyF+
0TM8ukj13Xnfs7j/EvEhmkvBioZxaUpmZmyPfjxwv60pIgbz5MDmgK7iS4+3mX6U
A5/TR5d8mUgjU+g4rk8Kb4Mu0UlXjIB0ttov0DiNewNwIRt18jA8+o+u3dpjq+sW
T8KOEUt+zwvo/7V3LvSye0rgTBIlDHCNAymg4VMk7BPZ7hm/ELNKjD+Jo2FR3qyH
B5T0Y3HsLuJvW5iB4YlcNHlsdu87kGJ55tukmi8mxdAQ4Q7e2RCOFvu396j3x+UC
B5iPNgiV5+I3lg02dZ77DnKxHZu8A/lJBdiB3QW0KtZB6awBdpUKD9jf1b0SHzUv
KBds0pjBqAlkd25HN7rOrFleaJ1/ctaJxQZBKT5ZPt0m9STJEadao0xAH0ahmbWn
OlFuhjuefXKnEgV4We0+UXgVCwOPjdAvBbI+e0ocS3MFEvzG6uBQE3xDk3SzynTn
jh8BCNAw1FtxNrQHusEwMFxIt4I7mKZ9YIqioymCzLq9gwQbooMDQaHWBfEbwrbw
qHyGO0aoSCqI3Haadr8faqU9GY/rOPNk3sgrDQoo//fb4hVC1CLQJ13hef4Y53CI
rU7m2Ys6xt0nUW7/vGT1M0NPAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNV
HRMBAf8EBTADAQH/MB0GA1UdDgQWBBR5tFnme7bl5AFzgAiIyBpY9umbbjANBgkq
hkiG9w0BAQsFAAOCAgEAVR9YqbyyqFDQDLHYGmkgJykIrGF1XIpu+ILlaS/V9lZL
ubhzEFnTIZd+50xx+7LSYK05qAvqFyFWhfFQDlnrzuBZ6brJFe+GnY+EgPbk6ZGQ
3BebYhtF8GaV0nxvwuo77x/Py9auJ/GpsMiu/X1+mvoiBOv/2X/qkSsisRcOj/KK
NFtY2PwByVS5uCbMiogziUwthDyC3+6WVwW6LLv3xLfHTjuCvjHIInNzktHCgKQ5
ORAzI4JMPJ+GslWYHb4phowim57iaztXOoJwTdwJx4nLCgdNbOhdjsnvzqvHu7Ur
TkXWStAmzOVyyghqpZXjFaH3pO3JLF+l+/+sKAIuvtd7u+Nxe5AW0wdeRlN8NwdC
jNPElpzVmbUq4JUagEiuTDkHzsxHpFKVK7q4+63SM1N95R1NbdWhscdCb+ZAJzVc
oyi3B43njTOQ5yOf+1CceWxG1bQVs5ZufpsMljq4Ui0/1lvh+wjChP4kqKOJ2qxq
4RgqsahDYVvTH9w7jXbyLeiNdd8XM2w9U/t7y0Ff/9yi0GE44Za4rF2LN9d11TPA
mRGunUHBcnWEvgJBQl9nJEiU0Zsnvgc/ubhPgXRR4Xq37Z0j4r7g1SgEEzwxA57d
emyPxgcYxn/eR44/KJ4EBs+lVDR3veyJm+kXQ99b21/+jh5Xos1AnX5iItreGCc=''')
    nonce = None
    error = None
    pretend_cert = False
    proxy = { 'checked': False, 'host': None, 'port': None }
    def __init__(self):
        self.nonce = ''.join(random().choice(ascii_lowercase + digits) for _ in range(16))
        self.error = import_error
    def __get_proxy(self):
        if not self.proxy['checked']:
            host = None
            port = None
            try:
                use_proxy = 'HTTPS_PROXY' in env and callable(getattr(http_lib.HTTPSConnection, 'set_tunnel'))
            except AttributeError:
                self.error.append('Proxy cannot be used (function set_tunnel() not available).')
                use_proxy = False
            if use_proxy:
                proxy_url = urlparse(env['HTTPS_PROXY'])
                if proxy_url.hostname:
                    host = proxy_url.hostname
                    if proxy_url.port:
                        port = proxy_url.port
                    else:
                        if proxy_url.scheme == 'http':
                            port = 1080
                        else:
                            host = None
            self.proxy['checked'] = True
            self.proxy['host'] = host
            self.proxy['port'] = port
        return (self.proxy['host'], self.proxy['port'])
    def check_online(self):
        host = self.CHECK_HOST
        port = 80
        (phost, pport) = self.__get_proxy()
        if phost:
            host = phost
            port = pport
        conn = http_lib.HTTPConnection(host, port=port, timeout=6)
        try:
            conn.request('HEAD', '/')
            conn.close()
        except:
            conn.close()
            return False
        return True
    def __get_sconn(self, host):
        (phost, pport) = self.__get_proxy()
        if self.pretend_cert:
            context = tls(cadata=self.ISRG_ROOT_X1_CERT)
        else:
            context = tls()
        if phost:
            conn = http_lib.HTTPSConnection(phost, port=pport, context=context)
            conn.set_tunnel(host, 443)
        else:
            conn = http_lib.HTTPSConnection(host, context=context)
        return conn
    def call_idm(self):
        for p in [False, True]:
            self.pretend_cert = p
            test = self.__get_sconn(self.IDM_HOST)
            try:
                test.request('HEAD', '/')
                test.getresponse()
            except SSLError:
                continue
            except:
                pass
            break
        task = lambda: url_open('https://' + self.IDM_HOST + self.PHASE1_URI % (self.nonce), new=2)
        browser = Thread(target=task)
        browser.start()
        return True
    def get_conf(self, pin):
        conn = self.__get_sconn(self.IDM_HOST)
        try:
            conn.request('POST', self.PHASE2_URI % (self.nonce, pin))
            result = conn.getresponse()
        except:
            conn.close()
            self.error.append('HTTP POST to TU Chemnitz IdM server failed.')
            return {}
        try:
            conf = json_decode(result.read().decode('utf-8'))
        except:
            self.error.append('Login data decoding from TU Chemnitz IdM server failed.')
            conf = {}
        conn.close()
        return conf
    def wait_deployed(self, pin, data):
        if not data:
            return False
        max_try = self.DEPLOY_TRIES
        while not 'deploy_status_code' in data or data['deploy_status_code'] != self.DEPLOYSTATE_OK:
            sleep(self.DEPLOY_WAIT)
            conn = self.__get_sconn(self.IDM_HOST)
            try:
                conn.request('GET', self.PHASE2_URI % (self.nonce, pin))
                result = conn.getresponse()
            except:
                conn.close()
                self.error.append('Polling the TU Chemnitz IdM server failed.')
                return False
            try:
                data = json_decode(result.read().decode('utf-8'))
            except:
                self.error.append('Data decoding while polling TU Chemnitz IdM server failed.')
                data = {}
            conn.close()
            max_try -= 1
            if max_try <= 0:
                self.error.append('Maximum timeout reached while waiting for active configuration.')
                return False
        return True
try:
    from http.client import HTTPConnection
except:
    from httplib import HTTPConnection
try:
    from subprocess import DEVNULL
except ImportError:
    DEVNULL = open(os.devnull, 'wb')
class Messages(object):
    init_info = "Dieses Programm richtet den eduroam-WLAN-Zugang ein.\n\n- Ihr TU-Nutzerkonto (IdM-Portal) wird im Webbrowser geöffnet.\n- Wählen Sie dort ein Gerät oder legen Sie ein neues an.\n- Tragen Sie die angezeigte PIN in das Eingabefeld dieses Programms ein.\n\nDieses Programm wird durch Unterstützung des GÉANT-Projekts ermöglicht.\n\nVersion: %s" % (version)
    quit = "Wirklich beenden?"
    pin_prompt = "Bitte die im IdM-Portal angezeigte PIN eingeben!"
    wrong_pin = "Ihre gerätespezifischen Zugangsdaten konnten nicht abgerufen werden. (Falsche PIN?)"
    config_problem = "Das Konfigurieren Ihrer gerätespezifischen Zugangsdaten hat leider nicht geklappt. Bitte versuchen Sie es später noch einmal."
    installation_finished = "eduroam-WLAN-Zugang erfolgreich konfiguriert."
    not_online = "Sie sind aktuell nicht mit dem Internet verbunden (bspw. über das WLAN tu-chemnitz.de). Bitte richten Sie eine temporäre Internetverbindung ein!"
    idm_not_secure = "Eine sichere Verbindung zum TU-Chemnitz-IdM-Portal konnte nicht aufgebaut werden. Bitte TLS-unterbrechende Firewalls o.ä. abschalten."
    retry = "Erneut Konnektivität prüfen?"
    ca_dir_exists = "Das Verzeichnis {} existiert bereits; Dateien darin könnten überschrieben werden."
    cont = "Weiter?"
    dbus_conn_problem = "Keine Kommunikation via D-Bus möglich"
    nm_not_supported = "Diese Network-Manager-Version wird nicht unterstützt."
    nm_problem = "Problem bei der Kommunikation mit dem Network-Manager"
    cert_error = "Zertifikat nicht gefunden (wahrscheinlich ein Softwarefehler)"
    yes = "J"
    no = "N"
    alt_wpa_conf = "Die Konfiguration des Network-Manager ist fehlgeschlagen. Alternativ können Sie sich aus dem TU-Chemnitz-IdM-Portal eine wpa_supplicant-Konfiguration herunterladen."
    please_wait = "Bitte einen Augenblick gedulden!"
class Config(object):
    ca_dir = 'eduroam'
    if os.environ.get('XDG_DATA_HOME') is not None:
        ca_dir = os.path.join(os.environ.get('XDG_DATA_HOME'), ca_dir)
    else:
        ca_dir = os.path.join(os.environ.get('HOME'), '.local', 'share', ca_dir)
    ca_file = 'ca.pem'
    title = "TU Chemnitz: eduroam-Konfiguration"
    servers = None
    ssids = None
    eap_outer = ""
    eap_inner = ""
    server_match = ""
    anonymous_identity = ""
class InstallerData(object):
    graphics = ''
    zenity = ['zenity', '--title=' + Config.title, '--width=480']
    kdialog = ['kdialog', '--title', Config.title]
    def __init__(self):
        self.__get_graphics_support()
        self.show_info(Messages.init_info)
        if os.path.exists(Config.ca_dir):
            if self.ask(Messages.ca_dir_exists.format(Config.ca_dir), Messages.cont, 1):
                sys.exit(1)
            os.chmod(Config.ca_dir, 0o700)
        else:
            os.makedirs(Config.ca_dir, 0o700)
    def ask(self, question, prompt='', default=None):
        if self.graphics == 'tty':
            yes = Messages.yes[:1].upper()
            no = Messages.no[:1].upper()
            print("\n-------\n" + question + "\n")
            while True:
                tmp = prompt + " (" + Messages.yes + "/" + Messages.no + ") "
                if default == 1:
                    tmp += "[" + yes + "]"
                elif default == 0:
                    tmp += "[" + no + "]"
                try:
                    inp = raw_input(tmp)
                except:
                    inp = input(tmp)
                if inp == '':
                    if default == 1:
                        return 0
                    if default == 0:
                        return 1
                i = inp[:1].upper()
                if i == yes:
                    return 0
                if i == no:
                    return 1
        if self.graphics == "zenity":
            command = self.zenity + ['--question', '--text=' + question + "\n\n" + prompt]
        elif self.graphics == 'kdialog':
            command = self.kdialog + ['--yesno', question + "\n\n" + prompt]
        returncode = subprocess.call(command, stderr=DEVNULL)
        return returncode
    def show_info(self, data):
        if self.graphics == 'tty':
            print(data)
            return
        if self.graphics == "zenity":
            command = self.zenity + ['--info', '--text=' + data]
        elif self.graphics == "kdialog":
            command = self.kdialog + ['--msgbox', data]
        else:
            sys.exit(1)
        subprocess.call(command, stderr=DEVNULL)
    def confirm_exit(self):
        ret = self.ask(Messages.quit)
        if ret == 0:
            sys.exit(1)
    def alert(self, text):
        if self.graphics == 'tty':
            print(text)
            return
        if self.graphics == 'zenity':
            command = self.zenity + ['--warning', '--text=' + text]
        elif self.graphics == "kdialog":
            command = self.kdialog + ['--sorry', text]
        else:
            sys.exit(1)
        subprocess.call(command, stderr=DEVNULL)
    def progressbar(self, text):
        if self.graphics == 'tty':
            print(text)
            return None
        if self.graphics == 'zenity':
            command = self.zenity + ['--progress', '--text=' + text, '--pulsate', '--no-cancel']
        elif self.graphics == "kdialog":
            command = self.kdialog + ['--passivepopup', text, '60']
        else:
            sys.exit(1)
        return subprocess.Popen(command, stderr=DEVNULL)
    def prompt_nonempty_string(self, prompt):
        if self.graphics == 'tty':
            string = re.sub(r'!$', ': ', prompt)
            while True:
                try:
                    inp = str(raw_input(string))
                except:
                    inp = str(input(string))
                output = inp.strip()
                if output != '':
                    return output
        if self.graphics == 'zenity':
            command = self.zenity + ['--entry', '--text=' + prompt]
        elif self.graphics == 'kdialog':
            command = self.kdialog + ['--inputbox', prompt]
        output = ''
        while not output:
            shell_command = subprocess.Popen(command, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
            out, err = shell_command.communicate()
            output = out.decode('utf-8').strip()
            if shell_command.returncode == 1:
                self.confirm_exit()
        return output
    def get_user_cred(self, api):
        while not api.call_idm():
            if inst.ask(Messages.idm_not_secure, Messages.retry, 1):
                sys.exit(3)
        pin = self.prompt_nonempty_string(Messages.pin_prompt)
        try:
            if not pin or not re.match(r'^\d+$', pin):
                raise Exception()
            conf = api.get_conf(pin)
        except:
            self.alert(Messages.wrong_pin)
            sys.exit(4)
        proc = self.progressbar(Messages.please_wait)
        if not api.wait_deployed(pin, conf):
            self.alert(Messages.config_problem)
            if proc:
                proc.kill()
            sys.exit(5)
        certfile = os.path.join(Config.ca_dir, Config.ca_file)
        if os.path.exists(certfile):
            os.chmod(certfile, 0o600)
        with open(certfile, 'w') as f:
            rootcrt = conf['certs'][0]
            f.write('-----BEGIN CERTIFICATE-----\n')
            for i in range(0, len(rootcrt), 64):
                f.write(rootcrt[i:i+64] + '\n')
            f.write('-----END CERTIFICATE-----\n')
        os.chmod(certfile, 0o400)
        self.username = conf['identity']
        self.password = conf['password']
        Config.servers = ["DNS:" + conf['subjectMatch']]
        Config.ssids = [conf['ssid']]
        Config.eap_outer = conf['eapMethod']
        Config.eap_inner = conf['phase2']
        Config.server_match = conf['subjectMatch']
        Config.anonymous_identity = re.sub(r'^unknownapp', 'linuxapp', conf['anonymousIdentity'])
        if proc:
            proc.kill()
    def __get_graphics_support(self):
        if os.environ.get('DISPLAY') is not None:
            shell_command = subprocess.Popen(['which', 'zenity'], stdout=subprocess.PIPE, stderr=subprocess.PIPE)
            shell_command.wait()
            if shell_command.returncode == 0:
                self.graphics = 'zenity'
            else:
                shell_command = subprocess.Popen(['which', 'kdialog'], stdout=subprocess.PIPE, stderr=subprocess.PIPE)
                out, err = shell_command.communicate()
                if shell_command.returncode == 0:
                    self.graphics = 'kdialog'
                else:
                    self.graphics = 'tty'
        else:
            self.graphics = 'tty'
class CatNMConfigTool(object):
    def __init__(self):
        self.cacert_file = None
        self.settings_service_name = None
        self.connection_interface_name = None
        self.system_service_name = None
        self.nm_version = None
        self.settings = None
        self.user_data = None
        self.bus = None
    def __connect_to_NM(self):
        try:
            self.bus = dbus.SystemBus()
        except dbus.exceptions.DBusException:
            return Messages.dbus_conn_problem
        self.system_service_name = "org.freedesktop.NetworkManager"
        self.check_nm_version()
        if self.nm_version == "0.9" or self.nm_version == "1.0":
            self.settings_service_name = self.system_service_name
            self.connection_interface_name = "org.freedesktop.NetworkManager.Settings.Connection"
            sysproxy = self.bus.get_object(self.settings_service_name, "/org/freedesktop/NetworkManager/Settings")
            self.settings = dbus.Interface(sysproxy, "org.freedesktop.NetworkManager.Settings")
        elif self.nm_version == "0.8":
            self.settings_service_name = "org.freedesktop.NetworkManager"
            self.connection_interface_name = "org.freedesktop.NetworkManagerSettings.Connection"
            sysproxy = self.bus.get_object(self.settings_service_name, "/org/freedesktop/NetworkManagerSettings")
            self.settings = dbus.Interface(sysproxy, "org.freedesktop.NetworkManagerSettings")
        else:
            return Messages.nm_not_supported
        return True
    def __check_opts(self):
        self.cacert_file = os.path.join(Config.ca_dir, Config.ca_file)
        if not os.path.isfile(self.cacert_file):
            return Messages.cert_error
        return True
    def check_nm_version(self):
        try:
            proxy = self.bus.get_object(self.system_service_name, "/org/freedesktop/NetworkManager")
            props = dbus.Interface(proxy, "org.freedesktop.DBus.Properties")
            version = props.Get("org.freedesktop.NetworkManager", "Version")
        except dbus.exceptions.DBusException:
            version = "0.8"
        if re.match(r'^1\.', version):
            self.nm_version = "1.0"
            return
        if re.match(r'^0\.9', version):
            self.nm_version = "0.9"
            return
        if re.match(r'^0\.8', version):
            self.nm_version = "0.8"
            return
        else:
            self.nm_version = "???"
            return
    def byte_to_string(self, barray):
        return "".join([chr(x) for x in barray])
    def __delete_existing_connections(self, ssid):
        try:
            conns = self.settings.ListConnections()
        except dbus.exceptions.DBusException:
            return False
        for each in conns:
            con_proxy = self.bus.get_object(self.system_service_name, each)
            connection = dbus.Interface(con_proxy, "org.freedesktop.NetworkManager.Settings.Connection")
            try:
               connection_settings = connection.GetSettings()
               if connection_settings['connection']['type'] == '802-11-wireless':
                   conn_ssid = self.byte_to_string(connection_settings['802-11-wireless']['ssid'])
                   if conn_ssid == ssid:
                       connection.Delete()
            except dbus.exceptions.DBusException:
               pass
        return True
    def __add_connection(self, ssid):
        server_alt_subject_name_list = dbus.Array(Config.servers)
        server_name = Config.server_match
        if self.nm_version == "0.9" or self.nm_version == "1.0":
             match_key = 'altsubject-matches'
             match_value = server_alt_subject_name_list
        else:
             match_key = 'subject-match'
             match_value = server_name
        s_8021x_data = {
            'eap': [Config.eap_outer.lower()],
            'identity': self.user_data.username,
            'ca-cert': dbus.ByteArray("file://{0}\0".format(self.cacert_file).encode('utf8')),
             match_key: match_value
        }
        if Config.eap_outer == 'PEAP' or Config.eap_outer == 'TTLS':
            s_8021x_data['password'] = self.user_data.password
            s_8021x_data['phase2-auth'] = Config.eap_inner.lower()
            s_8021x_data['anonymous-identity'] = Config.anonymous_identity
            s_8021x_data['password-flags'] = 0
        s_con = dbus.Dictionary({
            'type': '802-11-wireless',
            'uuid': str(uuid.uuid4()),
            'permissions': ['user:' + os.environ.get('USER')],
            'id': ssid
        })
        s_wifi = dbus.Dictionary({
            'ssid': dbus.ByteArray(ssid.encode('utf8')),
            'security': '802-11-wireless-security'
        })
        s_wsec = dbus.Dictionary({
            'key-mgmt': 'wpa-eap',
            'proto': ['rsn', ],
            'pairwise': ['ccmp', ],
            'group': ['ccmp', 'tkip']
        })
        s_8021x = dbus.Dictionary(s_8021x_data)
        s_ip4 = dbus.Dictionary({'method': 'auto'})
        s_ip6 = dbus.Dictionary({'method': 'auto'})
        con = dbus.Dictionary({
            'connection': s_con,
            '802-11-wireless': s_wifi,
            '802-11-wireless-security': s_wsec,
            '802-1x': s_8021x,
            'ipv4': s_ip4,
            'ipv6': s_ip6
        })
        self.settings.AddConnection(con)
    def add_connections(self, user_data):
        check_ok = self.__check_opts()
        if not check_ok:
            user_data.alert(check_ok)
            return None
        self.user_data = user_data
        conn_ok = self.__connect_to_NM()
        if not conn_ok:
            user_data.alert(conn_ok)
            return None
        for ssid in Config.ssids:
            if self.__delete_existing_connections(ssid):
                self.__add_connection(ssid)
            else:
                user_data.alert(Messages.nm_problem)
                return None
        return True
inst = InstallerData()
if import_error:
    inst.alert('\n'.join(import_error))
    sys.exit(255)
api = DevApi()
if api.error:
    inst.alert('\n'.join(api.error))
    sys.exit(254)
while not api.check_online():
    if inst.ask(Messages.not_online, Messages.retry, 1):
        sys.exit(2)
inst.get_user_cred(api)
config_tool = CatNMConfigTool()
if config_tool.add_connections(inst) is None:
    inst.show_info(Messages.alt_wpa_conf)
    sys.exit(1)
inst.show_info(Messages.installation_finished)
