/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.swing.flash;

import biz.papercut.pcng.util.Messages;
import biz.papercut.pcng.util.swing.SwingUtils;
import biz.papercut.pcng.util.swing.flash.FlashContent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlashMessage
extends JPanel
implements FlashContent {
    protected static final Logger logger = LoggerFactory.getLogger(FlashMessage.class);
    public static final Color DEFAULT_INFO_BACKGROUND = Color.decode("#DDFFDD");
    public static final Color DEFAULT_INFO_FOREGROUND = Color.decode("#006634");
    public static final Color DEFAULT_WARN_BACKGROUND = Color.decode("#FFFFCE");
    public static final Color DEFAULT_WARN_FOREGROUND = Color.decode("#B38F00");
    public static final Color DEFAULT_ERROR_BACKGROUND = Color.decode("#FFCCCC");
    public static final Color DEFAULT_ERROR_FOREGROUND = Color.decode("#CC0000");
    private final JButton _okButton;
    private volatile FlashContent.FlashContentEventHandler _eventHandler;

    public FlashMessage(Builder builder) {
        String title = StringUtils.trimToNull((String)builder._title);
        String text = StringUtils.trimToEmpty((String)builder._text).replace("\n", "<br />");
        int pad = 10;
        this.setLayout(new BorderLayout(pad, pad));
        this.setOpaque(true);
        this.setBackground(builder._background);
        this.setForeground(builder._foreground);
        this.setBorder(BorderFactory.createLineBorder(builder._foreground, 2));
        if (title != null) {
            JPanel titlePanel = new JPanel(new BorderLayout());
            titlePanel.setBackground(builder._foreground);
            titlePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JLabel titleLabel = new JLabel(title);
            titleLabel.setForeground(builder._background);
            titlePanel.add((Component)titleLabel, "West");
            this.add((Component)titlePanel, "North");
        }
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout(pad, pad));
        contentPanel.setBackground(builder._background);
        contentPanel.setBorder(BorderFactory.createEmptyBorder(pad, pad, pad, pad));
        JLabel textLabel = new JLabel("<html><center>" + text + "</center></html>");
        contentPanel.add((Component)textLabel, "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setOpaque(false);
        this._okButton = new JButton(Messages.getString(this.getClass(), "FlashMessage.ok", new String[0]));
        SwingUtils.setOpaqueIfRequired(this._okButton);
        this._okButton.addActionListener(e -> {
            if (this._eventHandler != null) {
                this._eventHandler.dismiss();
            }
        });
        buttonPanel.add((Component)this._okButton, "East");
        contentPanel.add((Component)buttonPanel, "South");
        this.add((Component)contentPanel, "Center");
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setEventHandler(FlashContent.FlashContentEventHandler eventHandler) {
        this._eventHandler = eventHandler;
    }

    @Override
    public void showing() {
        this._okButton.requestFocusInWindow();
    }

    public static class ErrorBuilder
    extends Builder {
        public ErrorBuilder(String text) {
            super(text);
            this.background(DEFAULT_ERROR_BACKGROUND);
            this.foreground(DEFAULT_ERROR_FOREGROUND);
        }
    }

    public static class WarnBuilder
    extends Builder {
        public WarnBuilder(String text) {
            super(text);
            this.background(DEFAULT_WARN_BACKGROUND);
            this.foreground(DEFAULT_WARN_FOREGROUND);
        }
    }

    public static class Builder {
        private final String _text;
        private String _title;
        private Color _background = DEFAULT_INFO_BACKGROUND;
        private Color _foreground = DEFAULT_INFO_FOREGROUND;

        public Builder(String text) {
            this._text = text;
        }

        public Builder title(String title) {
            this._title = title;
            return this;
        }

        public Builder background(Color background) {
            this._background = background;
            return this;
        }

        public Builder foreground(Color foreground) {
            this._foreground = foreground;
            return this;
        }

        public FlashMessage build() {
            logger.debug("Message: " + this._text + (String)(StringUtils.isNotBlank((String)this._title) ? " Title: " + this._title : ""));
            return new FlashMessage(this);
        }
    }
}

