/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.swing;

import biz.papercut.pcng.util.swing.GlassImage;
import java.net.URL;
import javax.swing.SwingUtilities;

public class FadeImage
extends GlassImage {
    private volatile Thread _fadeWorker;

    public FadeImage(URL imageResource, float intialAlpha) {
        super(imageResource, intialAlpha);
    }

    public void fadeToAlpha(float finalAlpha, long durationMs) {
        if (this._fadeWorker != null) {
            this._fadeWorker.interrupt();
        }
        FadeImage fadeImage = this;
        int pulseDurationMs = 50;
        float currentAlpha = this.getAlpha();
        this._fadeWorker = new Thread(() -> {
            try {
                int i = 1;
                while ((long)i < durationMs / 50L) {
                    float value = (finalAlpha - currentAlpha) / (float)(durationMs / 50L) * (float)i + currentAlpha;
                    fadeImage.setAlphaOnEventDispatchThread(value);
                    Thread.sleep(50L);
                    ++i;
                }
                fadeImage.setAlphaOnEventDispatchThread(finalAlpha);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        this._fadeWorker.setDaemon(true);
        this._fadeWorker.start();
    }

    private void setAlphaOnEventDispatchThread(float alpha) {
        Runnable change = () -> this.setAlpha(alpha);
        if (SwingUtilities.isEventDispatchThread()) {
            change.run();
        } else {
            SwingUtilities.invokeLater(change);
        }
    }
}

