/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class ThreadDetails {
    public static final String USER = "USER";
    public static final String RPC_REMOTE_ADDRESS = "RPC_REMOTE_ADDRESS";
    public static final String REQUEST_REMOTE_ADDRESS = "REQUEST_REMOTE_ADDRESS";
    public static final String RPC_ACTIVE_THREAD_COUNT = "RPC_ACTIVE_THREAD_COUNT";
    public static final String RPC_CONTINUATION = "RPC_CONTINUATION";
    public static final String USE_SECONDARY_DATASOURCE = "USE_SECONDARY_DATASOURCE";
    public static final String USE_DATASOURCE_KEY = "USE_DATASOURCE";
    private static final ThreadLocal<Map<String, Object>> _detailsHolder = ThreadLocal.withInitial(HashMap::new);

    private ThreadDetails() {
    }

    private static Map<String, Object> getDetailsMap() {
        return _detailsHolder.get();
    }

    @Nullable
    public static Object getValue(String name) {
        Map<String, Object> m = ThreadDetails.getDetailsMap();
        return m.get(name);
    }

    public static <V> V computeIfAbsent(String name, Function<String, ? extends V> mappingFunction, Class<V> cl) {
        return cl.cast(_detailsHolder.get().computeIfAbsent(name, mappingFunction));
    }

    @Nullable
    public static <T> T getValue(String name, Class<T> clazz) {
        return (T)ThreadDetails.getValue(name);
    }

    public static <T> T getValue(String name, T defaultValue) {
        Object v = ThreadDetails.getValue(name);
        return (T)(v == null ? defaultValue : v);
    }

    public static void setValue(String name, @Nullable Object value) {
        Map<String, Object> m = ThreadDetails.getDetailsMap();
        m.put(name, value);
    }

    public static void removeValue(String name) {
        Map<String, Object> m = ThreadDetails.getDetailsMap();
        m.remove(name);
    }

    public static void clearAll() {
        Map<String, Object> m = ThreadDetails.getDetailsMap();
        m.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithValue(String name, Object value, Runnable runnable) {
        Object originalValue = ThreadDetails.getValue(name);
        try {
            ThreadDetails.setValue(name, value);
            runnable.run();
        }
        finally {
            ThreadDetails.setValue(name, originalValue);
        }
    }
}

