/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.ContextAwareTrustAllManager;
import biz.papercut.pcng.util.ProcessUtils;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import java.io.File;
import java.io.StringReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetworkUtils {
    private static final Logger logger = LoggerFactory.getLogger(NetworkUtils.class);
    private static final Comparator<? super String> IPV4_FIRST_COMPARATOR = (left, right) -> {
        boolean rightIsV4;
        boolean leftIsV4 = NetworkUtils.isIpV4Address(left);
        if (leftIsV4 == (rightIsV4 = NetworkUtils.isIpV4Address(right))) {
            return 0;
        }
        if (leftIsV4) {
            return -1;
        }
        return 1;
    };
    private static final Pattern REGEX_IP_ADDRESS = Pattern.compile("\\b\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\b");
    private static final Pattern REGEX_STRIP_WIN_DOMAIN_PREFIX = Pattern.compile("[^\\\\]+?\\\\(.+)");
    private static final Pattern REGEX_STRIP_AT_DOMAIN_SUFFIX = Pattern.compile("([^@]+?)@.*");
    private static final Pattern REGEX_VALID_FILENAME_WIN = Pattern.compile("# Match a valid Windows filename (unspecified file system).          \n^                                # Anchor to start of string.        \n(?!                              # Assert filename is not: CON, PRN, \n  (?:                            # AUX, NUL, COM1, COM2, COM3, COM4, \n    CON|PRN|AUX|NUL|             # COM5, COM6, COM7, COM8, COM9,     \n    COM[1-9]|LPT[1-9]            # LPT1, LPT2, LPT3, LPT4, LPT5,     \n  )                              # LPT6, LPT7, LPT8, and LPT9...     \n  (?:\\.[^.]*)?                  # followed by optional extension    \n  $                              # and end of string                 \n)                                # End negative lookahead assertion. \n[^<>:\"/\\\\|?*\\x00-\\x1F]*     # Zero or more valid filename chars.\n[^<>:\"/\\\\|?*\\x00-\\x1F\\ .]  # Last char is not a space or dot.  \n$                                # Anchor to end of string.            ", 70);

    private NetworkUtils() {
    }

    @Nullable
    public static String getComputerName() {
        String hostname = null;
        try {
            InetAddress address = InetAddress.getLocalHost();
            hostname = address.getHostName();
        }
        catch (UnknownHostException noIpAddrException) {
            logger.debug("Cannot get hostname because name not resolvable: {}", (Object)String.valueOf(noIpAddrException));
        }
        if (StringUtils.isBlank((String)hostname) && SystemUtils.IS_OS_UNIX) {
            StringBuffer stdout = new StringBuffer();
            StringBuffer stderr = new StringBuffer();
            try {
                int status = ProcessUtils.execAndGetOutput(new String[]{"hostname"}, stdout, stderr);
                if (status == 0) {
                    logger.debug("hostname returned: {}", (Object)stdout);
                    List lines = CharStreams.readLines((Readable)new StringReader(stdout.toString()));
                    if (!lines.isEmpty()) {
                        hostname = ((String)lines.get(0)).trim();
                    }
                }
            }
            catch (Exception e) {
                logger.error("Unable to get hostname by running hostname command", (Throwable)e);
            }
        }
        if (StringUtils.isBlank((String)hostname)) {
            hostname = System.getenv("COMPUTERNAME");
        }
        if (StringUtils.isBlank((String)hostname)) {
            hostname = System.getenv("HOSTNAME");
        }
        return hostname;
    }

    public static Optional<String> getLocalHostHardwareAddress() {
        block5: {
            try {
                NetworkInterface network = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
                if (network == null) {
                    logger.warn("Unable to determine interface for local host");
                    break block5;
                }
                byte[] hardwareAddress = network.getHardwareAddress();
                if (hardwareAddress == null) {
                    logger.warn("Unable to determine network hardware address for local host");
                    break block5;
                }
                String mac = String.valueOf(Hex.encodeHex((byte[])hardwareAddress));
                return Optional.of(mac);
            }
            catch (UnknownHostException uhe) {
                logger.warn("Unable to determine interface for local host", (Throwable)uhe);
            }
            catch (SocketException se) {
                logger.warn("Error determining network hardware address", (Throwable)se);
            }
        }
        return Optional.empty();
    }

    @Nullable
    public static String getHostFromUri(@Nullable String uri) {
        if (StringUtils.isBlank((String)uri)) {
            return null;
        }
        String scheme = PhysicalId.NET.getScheme();
        if (uri.contains(PhysicalId.IPP.getScheme())) {
            scheme = PhysicalId.IPP.getScheme();
            uri = StringUtils.substring((String)uri, (int)StringUtils.indexOf((String)uri, (String)scheme));
        }
        return NetworkUtils.getHostFromUri(uri, scheme);
    }

    @Nullable
    public static String getHostFromUri(String uri, String scheme) {
        int firstSlash;
        if (!StringUtils.isBlank((String)scheme)) {
            if (!StringUtils.startsWith((String)uri, (String)scheme)) {
                return null;
            }
            uri = StringUtils.removeStart((String)uri, (String)scheme);
        }
        uri = uri.substring(0, (firstSlash = StringUtils.indexOf((String)uri, (String)"/")) > 0 ? firstSlash : uri.length());
        int firstAt = StringUtils.indexOf((String)uri, (String)"@");
        try {
            uri = uri.substring(firstAt < 0 ? 0 : firstAt + 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            return null;
        }
        Pattern reHostCapture = Pattern.compile("^(?:\\[([^\\]]*)\\].*)|((?:[\\p{XDigit}]{0,4}:){2,7}[^:]*)|(?:([^:]+):[^:]+)|(?:([^\\[\\]:]+))$");
        Matcher alternation = reHostCapture.matcher(uri);
        if (alternation.matches()) {
            for (UriFmt i : UriFmt.values()) {
                Object captureString = alternation.group(i.value);
                if (null == captureString) continue;
                if (i == UriFmt.BRACKETEDIPV6) {
                    Pattern reIpv6addrz;
                    Matcher mIpv6addrz;
                    if (Pattern.compile("^v\\p{XDigit}\\..*").matcher((CharSequence)captureString).matches()) {
                        try {
                            captureString = ((String)captureString).substring(StringUtils.indexOf((String)captureString, (String)".") + 1);
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            return null;
                        }
                        if (StringUtils.indexOf((String)captureString, (String)"+") == -1 || StringUtils.indexOf((String)captureString, (String)"+") == ((String)captureString).length()) {
                            return null;
                        }
                        String zoneId = ((String)captureString).substring(StringUtils.indexOf((String)captureString, (String)"+") + 1);
                        if (StringUtils.indexOf((String)zoneId, (String)"%") != -1) {
                            try {
                                zoneId = new URI(zoneId).getPath();
                            }
                            catch (URISyntaxException e1) {
                                return null;
                            }
                            try {
                                captureString = ((String)captureString).substring(0, StringUtils.indexOf((String)captureString, (String)"+")) + "%" + zoneId;
                            }
                            catch (StringIndexOutOfBoundsException e) {
                                return null;
                            }
                            return captureString;
                        }
                    }
                    if ((mIpv6addrz = (reIpv6addrz = Pattern.compile("^([\\p{XDigit}\\:]+)%25([^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]+)$")).matcher((CharSequence)captureString)).matches()) {
                        if (mIpv6addrz.groupCount() < 2) {
                            return captureString;
                        }
                        String zoneId = mIpv6addrz.group(2);
                        try {
                            zoneId = new URI(zoneId).getPath();
                        }
                        catch (URISyntaxException e) {
                            return captureString;
                        }
                        return mIpv6addrz.group(1) + "%" + zoneId;
                    }
                }
                if ((i == UriFmt.HOSTANDPORT || i == UriFmt.HOSTONLY) && StringUtils.endsWith((String)captureString, (String)".ipv6-literal.net")) {
                    captureString = StringUtils.remove((String)captureString, (String)".ipv6-literal.net");
                    captureString = StringUtils.replace((String)captureString, (String)"-", (String)":");
                }
                return captureString;
            }
        }
        return null;
    }

    public static List<String> getHardwareAddresses() {
        Enumeration<NetworkInterface> nis;
        ArrayList addrs = Lists.newArrayList();
        try {
            nis = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            logger.warn("Unable to enumerate network interfaces. {}", (Object)e.getMessage(), (Object)e);
            return addrs;
        }
        while (nis != null && nis.hasMoreElements()) {
            NetworkInterface ni;
            block8: {
                ni = nis.nextElement();
                try {
                    if (!ni.isUp() || ni.isPointToPoint() || ni.isVirtual()) continue;
                    if (ni.isLoopback()) {
                    }
                    break block8;
                }
                catch (SocketException e) {
                    logger.warn("Unable to determine type of network interface: {}", (Object)ni, (Object)e);
                }
                continue;
            }
            try {
                byte[] hwAddr = ni.getHardwareAddress();
                if (hwAddr == null || hwAddr.length <= 0) continue;
                addrs.add(String.valueOf(Hex.encodeHex((byte[])hwAddr)));
            }
            catch (SocketException e) {
                logger.warn("Unable to obtain hardware address for interface: {}", (Object)ni, (Object)e);
            }
        }
        return addrs;
    }

    public static String stripDomainOffHostname(String hostname) {
        return StringUtils.substringBefore((String)hostname, (String)".");
    }

    @Nullable
    public static String getIpAddress() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            if (!NetworkUtils.isLoopbackAddress(addr.getHostAddress())) {
                return addr.getHostAddress();
            }
        }
        catch (UnknownHostException e) {
            logger.debug("Unable to obtain localhost address.", (Throwable)e);
        }
        List<String> ips = NetworkUtils.getAllIpAddresses();
        if (!ips.isEmpty()) {
            return ips.get(0);
        }
        return null;
    }

    public static List<String> getAllIpAddresses() {
        List<String> ips = NetworkUtils.getIpAddresses().stream().filter(ip -> !NetworkUtils.isLoopbackAddress(ip)).distinct().sorted(IPV4_FIRST_COMPARATOR).collect(Collectors.toList());
        if (ips.isEmpty()) {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                ips.add(addr.getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return ips;
    }

    public static List<String> getAllLoopbackIpAddresses() {
        return NetworkUtils.getIpAddresses().stream().filter(NetworkUtils::isLoopbackAddress).distinct().sorted(IPV4_FIRST_COMPARATOR).collect(Collectors.toList());
    }

    private static Set<String> getIpAddresses() {
        LinkedHashSet<String> ips = new LinkedHashSet<String>();
        try {
            for (NetworkInterface intf : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                if (!intf.isUp()) continue;
                for (InetAddress ip : Collections.list(intf.getInetAddresses())) {
                    ips.add(ip.getHostAddress());
                }
            }
        }
        catch (Throwable t1) {
            logger.debug("Error obtaining network interfaces: " + t1.getMessage(), t1);
            try {
                InetAddress[] allAddresses;
                String hostname = InetAddress.getLocalHost().getHostName();
                for (InetAddress inetA : allAddresses = InetAddress.getAllByName(hostname)) {
                    ips.add(inetA.getHostAddress());
                }
            }
            catch (Throwable t2) {
                logger.debug("Error obtaining address by hostname: " + t2.getMessage(), t2);
            }
        }
        return ips;
    }

    public static String getUserHomeDirectory() {
        File profileDir;
        String profileDirPath;
        String homeDir = System.getProperty("user.home");
        if (SystemUtils.IS_OS_WINDOWS && SystemUtils.isJavaVersionAtLeast((int)150) && StringUtils.isNotEmpty((String)(profileDirPath = System.getenv("USERPROFILE"))) && (profileDir = new File(profileDirPath)).exists()) {
            homeDir = profileDir.getAbsolutePath();
        }
        return homeDir;
    }

    @Deprecated
    public static void safelySetupHTTPSToIgnoreHostnameAndTrustErrors() {
        try {
            NetworkUtils.setupHTTPSToIgnoreHostnameAndTrustErrors();
        }
        catch (GeneralSecurityException exception) {
            logger.error("Unable customize SSL error handling", (Throwable)exception);
        }
    }

    public static void safelySetupHTTPSToIgnoreHostnameAndTrustErrors(String packageOrClass, String ... morePackagesAndClasses) {
        try {
            NetworkUtils.setupHTTPSToIgnoreHostnameAndTrustErrors(packageOrClass, morePackagesAndClasses);
        }
        catch (GeneralSecurityException exception) {
            logger.error("Unable customize SSL error handling", (Throwable)exception);
        }
    }

    @Deprecated
    public static void setupHTTPSToIgnoreHostnameAndTrustErrors() throws NoSuchAlgorithmException, KeyManagementException {
        NetworkUtils.setupHTTPSToIgnoreHostnameAndTrustErrors(NetworkUtils.getSslContext());
    }

    @Deprecated
    public static void setupHTTPSToIgnoreHostnameAndTrustErrors(SSLContext sslContext) throws KeyManagementException {
        ContextAwareTrustAllManager.getInstance().inject(sslContext);
    }

    public static void setupHTTPSToIgnoreHostnameAndTrustErrors(String packageOrClass, String ... morePackagesAndClasses) throws NoSuchAlgorithmException, KeyManagementException {
        ContextAwareTrustAllManager.getInstance(packageOrClass, morePackagesAndClasses).inject(NetworkUtils.getSslContext());
    }

    private static SSLContext getSslContext() throws NoSuchAlgorithmException {
        return SSLContext.getInstance("SSL");
    }

    public static void setupHTTPSToIgnoreHostnameAndTrustErrors(HttpsURLConnection conn) throws NoSuchAlgorithmException, KeyManagementException {
        conn.setSSLSocketFactory(NetworkUtils.getTrustAllSSLSocketFactory());
        conn.setHostnameVerifier(NetworkUtils.createTrustAllHostnameVerifier());
    }

    public static SSLSocketFactory getTrustAllSSLSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslctx = NetworkUtils.getSslContext();
        sslctx.init(null, NetworkUtils.getTrustAllTrustManager(), null);
        return sslctx.getSocketFactory();
    }

    public static TrustManager[] getTrustAllTrustManager() {
        return new X509TrustManager[]{new TrustAllTrustManager()};
    }

    public static HostnameVerifier createTrustAllHostnameVerifier() {
        return new TrustAllHostnameVerifier();
    }

    public static boolean isIpV4Address(@Nullable String ip) {
        return (ip = StringUtils.substringBefore((String)StringUtils.trimToNull((String)ip), (String)":")) != null && REGEX_IP_ADDRESS.matcher(ip).matches();
    }

    public static boolean isIpV6Address(@Nullable String ip) {
        InetAddress a = NetworkUtils.constructInetAddressFromIPv6Format(ip);
        return a != null;
    }

    static boolean isPossibleIPv6Address(@Nullable String ip) {
        return ip != null && ip.contains(":") && ip.length() >= 3;
    }

    public static boolean isLinkLocalIPv6Address(String ip) {
        return NetworkUtils.isPossibleIPv6Address(ip) && StringUtils.left((String)ip, (int)5).toLowerCase().equals("fe80:");
    }

    public static boolean isLoopbackIPv6Address(@Nullable String ip) {
        return NetworkUtils.isPossibleIPv6Address(ip) && StringUtils.lowerCase((String)ip).matches("(fe80)?[:0]+(000)?1(%.*)?");
    }

    public static boolean isIpAddress(@Nullable String ip) {
        return NetworkUtils.isIpV4Address(ip) || NetworkUtils.isIpV6Address(ip);
    }

    public static boolean isLoopbackIPv4Address(@Nullable String ip) {
        return "127.0.0.1".equals(StringUtils.trimToEmpty((String)ip));
    }

    public static boolean isLoopbackAddress(@Nullable String ip) {
        return NetworkUtils.isLoopbackIPv4Address(ip) || NetworkUtils.isLoopbackIPv6Address(ip);
    }

    @Nullable
    public static String normalizeIpAddress(String ip) {
        if (NetworkUtils.isIpV4Address(ip = StringUtils.trimToEmpty((String)ip))) {
            return StringUtils.substringBefore((String)ip, (String)":");
        }
        InetAddress a = NetworkUtils.constructInetAddressFromIPv6Format(ip);
        if (a != null) {
            return a.getHostAddress();
        }
        return null;
    }

    @Nullable
    private static InetAddress constructInetAddressFromIPv6Format(@Nullable String ip) {
        if (!NetworkUtils.isPossibleIPv6Address(ip = StringUtils.trimToNull((String)ip))) {
            return null;
        }
        Object host = ip.charAt(0) == '[' && ip.charAt(ip.length() - 1) == ']' ? ip : "[" + ip + "]";
        int pos = ((String)host).indexOf("%");
        if (pos != -1) {
            host = ((String)host).substring(0, pos) + "]";
        }
        try {
            InetAddress[] a = InetAddress.getAllByName((String)host);
            if (a.length > 0) {
                return a[0];
            }
        }
        catch (Throwable t) {
            logger.debug("error converting ipv6 address: " + (String)host + ". " + t.getMessage(), t);
        }
        return null;
    }

    @Nullable
    public static String fetchCorrespondingHostnameOrIpV4Address(String hostnameOrIp) {
        boolean isIpAddress = NetworkUtils.isIpV4Address(hostnameOrIp) || NetworkUtils.isIpV6Address(hostnameOrIp);
        try {
            return isIpAddress ? Inet4Address.getByName(hostnameOrIp).getHostName() : Inet4Address.getByName(hostnameOrIp).getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.error("Unable to resolve " + hostnameOrIp + " to a corresponding IPv4 address or hostname");
            return null;
        }
    }

    public static String stripDomainOffUsername(String username) {
        if (username.indexOf(92) < 0 && username.indexOf(64) < 0) {
            return username;
        }
        String strippedUser = username;
        Matcher matcher = REGEX_STRIP_WIN_DOMAIN_PREFIX.matcher(strippedUser);
        if (matcher.find()) {
            strippedUser = matcher.group(1);
        }
        if ((matcher = REGEX_STRIP_AT_DOMAIN_SUFFIX.matcher(strippedUser)).find()) {
            strippedUser = matcher.group(1);
        }
        return strippedUser;
    }

    public static String getDomainOfUsername(String username) {
        if (!StringUtils.contains((String)username, (String)"@")) {
            return username;
        }
        if (username.indexOf(92) < 0 && username.indexOf(64) < 0) {
            return username;
        }
        return StringUtils.substringAfterLast((String)username, (String)"@");
    }

    public static boolean isValidFileNameWin(String filename) {
        Matcher matcher = REGEX_VALID_FILENAME_WIN.matcher(filename);
        return matcher.matches();
    }

    protected static class TrustAllHostnameVerifier
    implements HostnameVerifier {
        protected TrustAllHostnameVerifier() {
        }

        @Override
        public boolean verify(String arg0, SSLSession arg1) {
            return true;
        }
    }

    protected static class TrustAllTrustManager
    implements X509TrustManager {
        protected TrustAllTrustManager() {
        }

        @Override
        @Nullable
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
        }
    }

    public static enum PhysicalId {
        NET("net://"),
        IPP("https://");

        private final String scheme;

        private PhysicalId(String scheme) {
            this.scheme = scheme;
        }

        public String getScheme() {
            return this.scheme;
        }
    }

    private static enum UriFmt {
        BRACKETEDIPV6(1),
        BAREIPV6(2),
        HOSTANDPORT(3),
        HOSTONLY(4);

        private final int value;

        private UriFmt(int value) {
            this.value = value;
        }
    }
}

