/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.CustomMessagePrintDialog;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.common.ClientPrintJob;
import biz.papercut.pcng.common.client.dialogrequest.ClientDialogResponse;
import biz.papercut.pcng.common.client.dialogrequest.HTMLFormDialogResponse;
import biz.papercut.pcng.common.client.dialogrequest.MessageDialogRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.ListSelectionModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomHTMLFormPrintDialog
extends CustomMessagePrintDialog {
    private static final Logger logger = LoggerFactory.getLogger(CustomHTMLFormPrintDialog.class);

    public static CustomHTMLFormPrintDialog construct(JFrame owner, MessageDialogRequest request, ClientPrintJob job, ServerConnection conn, UserClientConfig config) {
        CustomHTMLFormPrintDialog d = new CustomHTMLFormPrintDialog(owner, request, job, conn, config);
        d.initializeMessageDialog();
        return d;
    }

    public CustomHTMLFormPrintDialog(JFrame owner, MessageDialogRequest request, ClientPrintJob job, ServerConnection conn, UserClientConfig config) {
        super(owner, request, job, conn, config);
    }

    @Override
    protected boolean handleButtonPress(String button) {
        Map<String, String> formData;
        try {
            formData = this.buildFormData((HTMLDocument)this._message.getDocument());
        }
        catch (Exception e) {
            logger.error("Error extracting form data: " + e.getMessage(), (Throwable)e);
            formData = Collections.emptyMap();
        }
        this._conn.setClientDialogResponse(this._job.getJobId(), this._request.getUniqueID(), (ClientDialogResponse)new HTMLFormDialogResponse(button, formData));
        return true;
    }

    private Map<String, String> buildFormData(HTMLDocument htmlDoc) {
        Element next;
        HashMap<String, String> data = new HashMap<String, String>();
        ElementIterator it = new ElementIterator(htmlDoc.getRootElements()[0]);
        while ((next = it.next()) != null) {
            if (!next.isLeaf()) continue;
            this.loadElementDataIntoMap(next, data);
        }
        return data;
    }

    private void loadElementDataIntoMap(Element elem, Map<String, String> data) {
        AttributeSet attr = elem.getAttributes();
        String name = (String)attr.getAttribute(HTML.Attribute.NAME);
        if (name == null) {
            return;
        }
        String value = null;
        HTML.Tag tag = (HTML.Tag)elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (tag == HTML.Tag.INPUT) {
            value = this.getInputElementData(attr);
        } else if (tag == HTML.Tag.TEXTAREA) {
            value = this.getTextAreaData(attr);
        } else if (tag == HTML.Tag.SELECT) {
            this.loadSelectData(attr, data);
        }
        if (name != null && value != null) {
            data.put(name, value);
        }
    }

    private String getInputElementData(AttributeSet attr) {
        ButtonModel m;
        Object model = attr.getAttribute(StyleConstants.ModelAttribute);
        String type = (String)attr.getAttribute(HTML.Attribute.TYPE);
        String value = null;
        if (type.equals("text") || type.equals("password")) {
            Document doc = (Document)model;
            try {
                value = doc.getText(0, doc.getLength());
            }
            catch (BadLocationException e) {
                value = null;
            }
        } else if (type.equals("submit") || type.equals("hidden")) {
            value = (String)attr.getAttribute(HTML.Attribute.VALUE);
            if (value == null) {
                value = "";
            }
        } else if ((type.equals("radio") || type.equals("checkbox")) && (m = (ButtonModel)model).isSelected() && (value = (String)attr.getAttribute(HTML.Attribute.VALUE)) == null) {
            value = "on";
        }
        return value;
    }

    private String getTextAreaData(AttributeSet attr) {
        Document doc = (Document)attr.getAttribute(StyleConstants.ModelAttribute);
        try {
            return doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private void loadSelectData(AttributeSet attr, Map<String, String> data) {
        ComboBoxModel model;
        Option option;
        String name = (String)attr.getAttribute(HTML.Attribute.NAME);
        if (name == null) {
            return;
        }
        Object m = attr.getAttribute(StyleConstants.ModelAttribute);
        if (m instanceof ListSelectionModel) {
            DefaultListModel model2 = (DefaultListModel)m;
            ListSelectionModel lsm = (ListSelectionModel)m;
            for (int i = 0; i < model2.getSize(); ++i) {
                if (!lsm.isSelectedIndex(i)) continue;
                Option option2 = (Option)model2.getElementAt(i);
                data.put(name, option2.getValue());
            }
        } else if (m instanceof ComboBoxModel && (option = (Option)(model = (ComboBoxModel)m).getSelectedItem()) != null) {
            data.put(name, option.getValue());
        }
    }
}

