/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.common;

import biz.papercut.pcng.util.ApplicationException;
import biz.papercut.pcng.util.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class SharedSecret {
    private static final String PROP_KEY = "secret";
    private static final String PROP_COMMENT = "Keep the contents of this file secure.";
    private final File _f;

    public SharedSecret(File f) {
        this._f = f;
    }

    public String getSecret() {
        String secret = null;
        Properties prop = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this._f);
            prop.load(fis);
            secret = prop.getProperty(PROP_KEY);
        }
        catch (IOException e) {
            try {
                throw new ApplicationException("Unable to read shared secret from file", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(fis);
        return secret;
    }

    public void setSecret(String secret) {
        Properties prop = new Properties();
        prop.setProperty(PROP_KEY, secret);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this._f);
            prop.store(fos, PROP_COMMENT);
        }
        catch (IOException e) {
            try {
                throw new ApplicationException("Unable to write shared secret file", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(fos);
    }
}

