/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputFilter;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecureSerializationFilter {
    private static final Logger logger = LoggerFactory.getLogger(SecureSerializationFilter.class);

    private SecureSerializationFilter() {
    }

    public static void installGlobalFilter(@NotNull String serializationConfigFile) {
        String pattern = SecureSerializationFilter.filterPattern(serializationConfigFile);
        if (pattern != null) {
            ObjectInputFilter.Config.setSerialFilter(ObjectInputFilter.Config.createFilter(pattern));
        }
    }

    private static String filterPattern(String serializationConfigFile) {
        Properties properties = SecureSerializationFilter.getFilterProperties(serializationConfigFile);
        String blackListPattern = SecureSerializationFilter.getMultiValueProperty(properties, "blacklist").stream().filter(StringUtils::isNotBlank).map(s -> "!" + s).collect(Collectors.joining(";"));
        String whiteListPattern = SecureSerializationFilter.getMultiValueProperty(properties, "whitelist").stream().filter(StringUtils::isNotBlank).collect(Collectors.joining(";"));
        if (StringUtils.isNotBlank((String)blackListPattern) && StringUtils.isNotBlank((String)whiteListPattern)) {
            logger.debug("Configure global de-serialization with black-list pattern: {}", (Object)blackListPattern);
            logger.debug("Configure global de-serialization with white-list pattern: {}", (Object)whiteListPattern);
            return blackListPattern + ";" + whiteListPattern;
        }
        if (StringUtils.isNotBlank((String)blackListPattern)) {
            logger.debug("Configure global de-serialization with black-list pattern: {}", (Object)blackListPattern);
            return blackListPattern;
        }
        if (StringUtils.isNotBlank((String)whiteListPattern)) {
            logger.debug("Configure global de-serialization with white-list pattern: {}", (Object)whiteListPattern);
            return whiteListPattern;
        }
        return null;
    }

    private static Properties getFilterProperties(String serializationConfigFile) {
        Properties properties;
        try {
            properties = SecureSerializationFilter.loadProperties(serializationConfigFile);
        }
        catch (IOException e) {
            logger.debug("Running with pre-set global de-serialization filter");
            properties = SecureSerializationFilter.defaultPatterns();
        }
        return properties;
    }

    private static Properties defaultPatterns() {
        Properties properties = new Properties();
        properties.setProperty("blacklist", "bsh.XThis, bsh.Interpreter,com.mchange.v2.c3p0.impl.*,org.apache.commons.beanutils.BeanComparator,org.apache.commons.collections.Transformer,org.apache.commons.collections.functors.*,org.apache.commons.collections4.functors.*,org.apache.commons.fileupload.disk.DiskFileItem,org.codehaus.groovy.runtime.*,org.apache.groovy.runtime.*,java.rmi.server.*,javax.xml.transform.Templates,org.hibernate.tuple.**,org.hibernate.type.*,org.hibernate.engine.**,com.sun.org.apache.xalan.internal.xsltc.*,org.mozilla.javascript.*,java.lang.reflect.Proxy,javax.management.**,org.springframework.aop.framework.JdkDynamicAopProxy,org.jboss.weld.interceptor.**,java.beans.EventHandler,java.util.Comparator,net.sf.json.JSONObject,org.python.core.*,org.reflections.Reflections");
        return properties;
    }

    private static List<String> getMultiValueProperty(Properties properties, String propName) {
        return Arrays.stream(properties.getProperty(propName, "").split(",")).map(s -> StringUtils.trim((String)s)).collect(Collectors.toList());
    }

    private static Properties loadProperties(String filePath) throws IOException {
        Properties properties = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream(filePath);){
            logger.debug("Loading serialization pattern configuration from {}", (Object)filePath);
            properties.load(fileInputStream);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return properties;
    }
}

