/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.common.card;

import biz.papercut.pcng.common.card.AsciiEncodedConverter;
import biz.papercut.pcng.common.card.CardNumberConverter;
import biz.papercut.pcng.common.card.Dec2HexConverter;
import biz.papercut.pcng.common.card.Hex2DecConverter;
import org.apache.commons.lang.StringUtils;

public class CardNumberConverterFactory {
    public static CardNumberConverter createConverterNoJavascript(String type) {
        if ("hex2dec".equalsIgnoreCase(type = StringUtils.trimToEmpty((String)type))) {
            return new Hex2DecConverter();
        }
        if ("dec2hex".equalsIgnoreCase(type)) {
            return new Dec2HexConverter();
        }
        if ("ascii-enc".equalsIgnoreCase(type)) {
            return new AsciiEncodedConverter();
        }
        if (type.toLowerCase().startsWith("class:")) {
            String classToLoad = type.substring(6);
            try {
                return (CardNumberConverter)Class.forName(classToLoad).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load card number converter class: " + type, e);
            }
        }
        throw new IllegalArgumentException("Unknown card number converter type: " + type);
    }

    public static void main(String[] args) {
        String hex = "946EBD28";
        String dec = "2490285352";
        String asciienc = "3934364542443238FFFFFFFFFFFFFFFF";
        CardNumberConverter hex2dec = CardNumberConverterFactory.createConverterNoJavascript("hex2dec");
        String result = hex2dec.convert(hex);
        System.out.printf("Result: %s\n", result);
        CardNumberConverter dec2hex = CardNumberConverterFactory.createConverterNoJavascript("dec2hex");
        result = dec2hex.convert(dec);
        System.out.printf("Result: %s\n", result);
        CardNumberConverter js = CardNumberConverterFactory.createConverterNoJavascript("javascript:c:/Development/tmp/cardtest.js");
        result = js.convert(hex);
        System.out.printf("Result: %s\n", result);
        CardNumberConverter ascii = CardNumberConverterFactory.createConverterNoJavascript("ascii-enc");
        result = ascii.convert(asciienc);
        System.out.printf("Result: %s\n", result);
    }
}

