/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;

public class RndRdr {
    private int datalength = 0;
    private int bufpos = 0;
    private int znext = 0;
    private int data_read = 0;
    private byte[] databuffer = null;
    private int[][] tab = null;
    private byte codeByte;
    private int nrecs;
    private boolean debugmode = false;
    private byte[] Dos_Str = new byte[]{0, -124, -108, -127, -114, -103, -102, -31, -81, -82, -11, -100};
    private byte[] Win_Str = "#\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df\u00bb\u00ab\u00a7\u00a3".getBytes();

    public RndRdr(URL uRL) {
        this(uRL, "default.gz", false);
    }

    public RndRdr(URL uRL, boolean bl) {
        this(uRL, "default.gz", bl);
    }

    public RndRdr(URL uRL, String string) {
        this(uRL, string, false);
    }

    public RndRdr(URL uRL, String string, boolean bl) {
        String string2 = uRL.getFile();
        String string3 = string2.substring(0, string2.lastIndexOf("/") + 1) + string;
        this.debugmode = bl;
        this.Dos_Str[3] = -127;
        this.Dos_Str[4] = -114;
        try {
            URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), string3);
            if (this.debugmode) {
                System.out.println("Open URL " + uRL2);
            }
            URLConnection uRLConnection = uRL2.openConnection();
            this.datalength = uRLConnection.getContentLength();
            if (this.debugmode) {
                System.out.println("connection datalength=" + this.datalength);
            }
            if (this.datalength > 0) {
                this.databuffer = new byte[3 * this.datalength];
                GZIPInputStream gZIPInputStream = new GZIPInputStream(new DataInputStream(uRLConnection.getInputStream()));
                int n = 0;
                int n2 = 0;
                this.bufpos = 0;
                while (n2 >= 0) {
                    n2 = gZIPInputStream.read(this.databuffer, n, 3 * this.datalength - n);
                    if (n2 <= 0) continue;
                    n += n2;
                }
                gZIPInputStream.close();
                if (this.debugmode) {
                    System.out.println(n + " Bytes read.");
                }
                this.data_read = n;
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("cannot connect to " + uRL);
        }
        catch (IOException iOException) {
            System.out.println("error reading " + string3);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println("memory allocation failed for data buffer of size " + this.datalength);
        }
        this.nrecs = 0;
        if (this.data_read > 0) {
            while (this.bufpos < this.data_read) {
                int n = this.indxOf((byte)10, this.databuffer, this.bufpos);
                this.bufpos += n + 1;
                ++this.nrecs;
            }
            this.codeByte = 0;
            if (this.debugmode) {
                System.out.println("Anzahl=" + this.nrecs + ",");
            }
            this.tab = new int[this.nrecs][2];
            this.bufpos = 0;
            for (int i = 0; i < this.nrecs; ++i) {
                this.tab[i][0] = this.bufpos;
                this.tab[i][1] = this.indxOf((byte)10, this.databuffer, this.bufpos) + 1;
                this.bufpos += this.tab[i][1];
            }
        }
    }

    public void setdebug(boolean bl) {
        this.debugmode = bl;
        if (this.debugmode) {
            System.out.println("debug mode on");
        }
    }

    private int indxOf(byte by, byte[] byArray) {
        int n = -1;
        for (int i = 0; i < byArray.length; ++i) {
            if (by != byArray[i]) continue;
            n = i;
        }
        return n;
    }

    private int indxOf(byte by, byte[] byArray, int n) {
        int n2 = -1;
        int n3 = 0;
        while (n3 + n < byArray.length && n2 < 0) {
            if (by == byArray[n3 + n]) {
                n2 = n3;
            }
            ++n3;
        }
        return n2;
    }

    private String getLine(int n) {
        int n2 = this.tab[n][0];
        int n3 = this.tab[n][1];
        byte[] byArray = new byte[n3 - 1];
        for (n = 0; n < n3 - 1; ++n) {
            byArray[n] = (byte)(this.databuffer[n + n2] ^ this.codeByte);
            int n4 = this.indxOf(byArray[n], this.Dos_Str);
            if (n4 <= 0) continue;
            byArray[n] = this.Win_Str[n4];
        }
        return new String(byArray);
    }

    public String getSlog(int n) {
        int n2 = Math.abs(n) % this.nrecs;
        String string = this.getLine(n2);
        if (string.charAt(0) == ' ') {
            String string2 = this.getLine(n2 - 1);
            return string2 + "\n" + string;
        }
        if (n2 < this.nrecs - 1) {
            String string3 = this.getLine(n2 + 1);
            if (string3.charAt(0) == ' ') {
                return string + "\n" + string3;
            }
            return string;
        }
        return string;
    }
}

