/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Panel;

public class BorderPanel
extends Panel {
    protected int shadow = 4;
    protected boolean raised = true;

    public BorderPanel() {
        this.raised = true;
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.setSize(84, 40);
    }

    public BorderPanel(boolean bl) {
        this.raised = bl;
    }

    protected void layoutParent() {
        Container container = this.getParent();
        if (container != null) {
            container.doLayout();
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = this.getSize();
        this.paintBorder(graphics, dimension);
    }

    protected void paintBorder(Graphics graphics, Dimension dimension) {
        Color color = this.getBackground();
        graphics.setColor(color);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        this.draw3DRect(graphics, 0, 0, dimension.width, dimension.height, this.raised);
    }

    public void draw3DRect(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        Color color = graphics.getColor();
        Color color2 = BorderPanel.avgColor(color, Color.white);
        Color color3 = BorderPanel.avgColor(color, Color.black);
        graphics.setColor(bl ? color2 : color3);
        int n5 = 0;
        while (n5 < this.shadow) {
            graphics.drawLine(n + n5, n2 + n5, n + n3 - 1 - n5, n2 + n5);
            graphics.drawLine(n + n5, n2 + n5, n + n5, n2 + n4 - 1 - n5);
            ++n5;
        }
        graphics.setColor(bl ? color3 : color2);
        int n6 = 0;
        while (n6 < this.shadow) {
            graphics.drawLine(n + n6, n2 + n4 - 1 - n6, n + n3 - 1 - n6, n2 + n4 - 1 - n6);
            graphics.drawLine(n + n3 - 1 - n6, n2 + n4 - 1 - n6, n + n3 - 1 - n6, n2 + n6);
            ++n6;
        }
        graphics.setColor(color);
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, n3 + 2, n4 + 2);
    }

    public static Color avgColor(Color color, Color color2) {
        return new Color((color.getRed() + color2.getRed()) / 2, (color.getGreen() + color2.getGreen()) / 2, (color.getBlue() + color2.getBlue()) / 2);
    }
}

