#!/usr/bin/gnuplot
#
# Extraplate your measurement data to a grid.
#
# AUTHOR: Hagen Wierstorf + mods by Christian Wagner
# gnuplot 5.2 patchlevel 2
#
# http://www.gnuplotting.org/circular-heat-map/

# define file to use - either 'sand_density' or 'sand_density_2'
name='sand_density_1'
set output name.".eps"
#########################################

reset

# load style 
set loadpath '~/.gnuplot'		# should be your local path to *.cfg data
load 'pal/sand.pal'			# load original example colormap
load 'one_column.cfg'		# load style for graphic

set cbrange [0:1]

# remove all unnecessary lines 
set tmargin screen 1	# remove all borders
set bmargin screen 0	# remove all borders
set border 0 back	# remove all borders
set size square
set xrange [-1.55:1.55]
set yrange [-1.55:1.55]
unset key		# remove 
unset colorbox		# remove 
unset tics		# remove 

# Draw container
r = 1.5
set object 1 circle front at 0,0 size r fillcolor rgb "black" lw 4

set multiplot

# === Plot heat map of interpolated data ===
set view map
set pm3d at b map
set dgrid3d 200,200,2
splot "sand_density_2.txt" u 2:3:5

###=== Plot measurement points ===###
unset object
plot "sand_density_2.txt" u 2:3:(0) w p ls 1

unset multiplot
