#!/bin/bash

# envsubst < template.sh 

datapath="data"
num_point_array=($(seq 500 500 1000))

function create_input(){
    # fills a file with random data
    # $1 filename for output
    # $2 number of datapoints
    for i in $(seq $2); do
	echo $(RANDOM%10000) > $1
    done
}

for num_point in $num_point_array; do
    path=$datapath/$num_point
    mkdir -p $path
    create_input $path/random_list.dat $num_point
done
