#!/usr/bin/gnuplot

set output "example_plot.pdf"
#########################################

# load style 
set loadpath '~/.gnuplot'		# should be your local path to *.cfg data
load 'pal/viridis.pal'			# load viridis colormap
load 'one_column_pdf.cfg'			# load style for graphic

# plot your actual data
set grid				# default: no grid
pi = GPVAL_pi
set ylabel "x"
set xlabel "y"
set xrange [-pi:pi]
set yrange [-1.2:1.2]

plot sin(x) ls 5 title "sin(x)"		# using ls you use colour AND style as defined in the color palette
					# custom definition of (lt, lc, lw) also possible
