#!/usr/bin/gnuplot
#
# Extraplate your measurement data to a grid.
#
# AUTHOR: Hagen Wierstorf
# gnuplot 5.2 patchlevel 2
#
# http://www.gnuplotting.org/circular-heat-map/

# define file to use - either 'sand_density' or 'sand_density_2'
name='sand_density_2'
set output name.".eps"
#########################################

reset

# load style 
set loadpath '~/.gnuplot'		# should be your local path to *.cfg data
load 'pal/sand.pal'			# load original example colormap
load 'one_column.cfg'		# load style for graphic

set cbrange [0:1]

# remove all unnecessary lines 
set tmargin screen 1	# remove all borders
set bmargin screen 0	# remove all borders
set border 0 back	# remove all borders
set size square
set xrange [-1.55:1.55]
set yrange [-1.55:1.55]
unset key		# remove 
unset colorbox		# remove 
unset tics		# remove 

# === Limit plot to circle ===
# Fit data to grid and store result in grid_data.txt
set table "tmp.txt"		# write grid-based data into tmp.txt
set dgrid3d 200,200,2
splot "sand_density_2.txt" u 2:3:5
unset table

# Draw container
r = 1.5
set object 1 circle front at 0,0 size r fillcolor rgb "black" lw 2

set multiplot		# allow plotting on top of each other

# === Plot heat map of interpolated data ===
set view map
set pm3d at b map
set dgrid3d 200,200,2 		# define grid for extrapolating data
splot "sand_density_2.txt" u 2:3:5

# === Plot measurement points ===
unset object
unset dgrid3d
unset pm3d
splot "sand_density.txt" u 2:3:(0) w p ls 1

# define circle function
circle(x,y,z) = x**2+y**2>r**2 ? NaN : z

###=== Plot heat map of interpolated data ===###
plot "tmp.txt" u 1:2:(circle($1,$2,$3)) w image

###=== Plot actual measurement points ===###
unset object	
r = 1.49 # make radius smaller to exclude interpolated edge points
set label 'normal' at -1,0.2 center front tc ls 1
set label 'dense' at 0.5,0.75 center front tc ls 1
set label 'very dense' at 0.3,-0.3 center front tc ls 1
plot "sand_density_2.txt" u (circle($2,$3,$2)):(circle($2,$3,$3)) w p ls 1

unset multiplot