#!/bin/bash

ACCURACY=10000

function calculate_pi(){
    # calculate pi from random values in file $1

    total=$(wc -l $1 | cut -d" " -f1)  # total number of values

    counter=0
    while read line; do
	x_val=$(echo $line | cut -d " " -f 1)
	y_val=$(echo $line | cut -d " " -f 2)
	distance=$(bc -l <<< "$x_val^2 + $y_val^2")
	if [[ $distance -le $(($ACCURACY*$ACCURACY)) ]]; then
	    counter=$((counter + 1))
	fi
    done <<< $(cat $1)
    
    pi=$(bc -l <<< "4*$counter/$total")
    echo $pi
}

# do the calculation
for random_list in $(find -name random_list.dat); do
    echo "Starting calculation using $random_list"
    echo "$(grep -o [0-9]* <<< $random_list) $(calculate_pi $random_list)" >> pi.dat
done
