#!/bin/bash

set -u  # Wirft Fehler sofern Variablen nicht gesetzt sind
# Ist nicht notwendig, kann aber manchmal bei Programmierfehlern vor dem Loeschung aller Dateien schuetzen.


# baue eine Funktion, die aus einer pdf eine doi zurückgibt
function pdf2doi {
    # nutze 'pdftotext', um den Text aus einer pdf in ein textfile zu schreiben
    pdftotext $1 2>/dev/null
    # Wegwerfen von stderr
    # grep -oP -m1 "10\.[0-9]{3,}/[-._;()/:a-zA-Z0-9]+" ${1//.pdf/.txt}
    grep -oP -m1 "10\.\d{3,}/[-._;()/:a-zA-Z0-9]+" ${1/%.pdf/.txt}
    # [\d] is aequivalent zu [0-9]
    # -P fuer Pearl
    # das "%" sorgt dafuer, dass nur der letzte Treffer ersetzt wird
    
    # entferne die temporäre txt-Datei
    rm ${1/%.pdf/.txt}

    # Alternativer regex string fuer die DOI
    # www.crossref.org/blog/dois-and-matching-regular-expressions
}


# Bibliographie-Information fuer eine gegeben DOI holen
function getbib {
    bib=$(curl -LH "Accept: text/bibliography; style=bibtex"  "http://dx.doi.org/$1" 2>/dev/null)
    if $(echo $bib | grep -q "This DOI cannot be found in the DOI System.") ; then
	echo "The DOI $1 konnte nicht ueber dx.doi.org gefunden werden." >&2
    else
	echo -e "$bib"
    fi
}


# durchsuche alle pdfs nach dois
for dateiname in *.pdf; do
	
    # extrahiere die doi mittels der eigens definierten Funktion pdf2doi
    doi=$(pdf2doi $dateiname)

    # search crossref, return bibstring and write to file
    # nutze die eigens definierte Funktion getbib
    getbib $doi | sed 's/@/\n@/g;s/},/},\n/g' | tee -a bibfile.bib
    
done
