#!/bin/bash


####################################
# Teil 1: grep
####################################

curl https://www.tu-chemnitz.de/physik/SKALMOD/ProCoSki.html > procoski.html

# Extrahiere alle h2 Ueberschriften
grep -oP "<h2.*</h2>" procoski.html
# Extrahiere alle Ueberschriften
grep -oP "<h\d.*</h\d>" procoski.html


# Extrahiere alle Datumsangabe
grep -oP "\d{1,2}\.\d{1,2}.\d{2,4}" procoski.html

####################################
# Teil 2: Stringvergleich
####################################

string="Text mit Leerzeichen"

if [[ "A" =~ . ]]; then echo "A ist irgendein Zeichen"; fi
if [[ "A" =~ [0-9] ]]; then echo "A ist kein Integer"; fi

####################################
# Teil 3: sed
####################################

# Ersetzen des ersten Treffers
sed 's/processor/Prozessor/'

# Ersetzen aller Treffer
sed 's/processor/Prozessor/g'

# Verkettung mehrere Befehle
sed 's/processor/Prozessor/g;s/family/Familie/g' /proc/cpuinfo

# Alternativer Trenner
echo $PWD | sed 's#/#\\#'

# Einruecken
sed 's/^/    /' /proc/cpuinfo

# Ersetzen aller Zahlen
sed 's/[0-9]/Zahl/g' /proc/cpuinfo

# String begrenzt durch zwei strings extrahieren
sed -n '/<head>/,/<\/head>/p' procoski.html

####################################
# Teil 4: Bonus
####################################
# einfache Moeglichkeit beim Ersetzen von globalen Variablen:
echo '$USER' > template.sh
echo '$PWD' >> template.sh
envsubst < template.sh

