package 
{
	import flash.display.SimpleButton;
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFieldType;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;

	
	/**
	 * ...
	 * @author Stephan
	 */
	public class show_table extends Sprite 
	{
		private var background:Sprite;
		public var table_height:Number = 0;
		public var table_width:Number = 0;
		public var csv:String = "";
		public var button:SimpleButton;
		
		public var format:TextFormat;
		public function show_table(t:Array,f:Array):void
		{
			csv_construct(t,f);
			
			background = new Sprite();
			this.addChild(background);
			format = new TextFormat();
			format.size = 15;
			format.align = TextFormatAlign.CENTER;
			
			table_height = f[1].length * 80 + 45;
			table_width = f[2].length * 80 + 205;
			
			background.graphics.lineStyle(1, 0x000000, 1);
			background.graphics.beginFill(0xffffe5, 1);
			background.graphics.drawRoundRect(2, 2, table_width, table_height, 0, 0);
			background.graphics.endFill();
			background.graphics.drawRoundRect(4, 4, table_width -4, table_height - 4, 0, 0);
			
			//table construction -------------------------------------------------------------------------------------------------------------------------
			
			for (var i:Number = 0; i < f[1].length; i++)
			{
				var domain:TextField = new TextField;
				domain.selectable = true;
				domain.borderColor = 0x000000;
				domain.border = true;
				domain.multiline = true;
				domain.height = 80;
				domain.width = 80;
				domain.background = false;
				domain.backgroundColor = 0xffffff;
				domain.type = TextFieldType.DYNAMIC;
				domain.restrict = "A-Z a-z 0-9";
				domain.maxChars = 30;
				this.addChild(domain);
				domain.x = 10;
				domain.y = 36 + i * domain.height;
				domain.htmlText = "<br>." + f[1][i] + "<br>" + String(t[i][0]);
				domain.setTextFormat(format);
				
				for (var j:Number = 0; j < f[2].length; j++)
				{
					if (i == 0)
					{
						var phrase:TextField = new TextField();
						phrase.selectable = true;
						phrase.borderColor = 0x000000;
						phrase.border = true;
						phrase.multiline = true;
						phrase.height = domain.height/4;
						phrase.width = 80;
						phrase.background = false;
						phrase.backgroundColor = 0xffffff;
						phrase.type = TextFieldType.DYNAMIC;
						phrase.restrict = "A-Z a-z 0-9";
						phrase.maxChars = 30;
						this.addChild(phrase);
						phrase.x = 110 + domain.width + domain.x + j * phrase.width;
						phrase.y = domain.y - domain.height/4;
						phrase.htmlText = String(f[2][j]);
						phrase.setTextFormat(format);
					}
					if (j == 0)
					{
						var absolute_desc:TextField = new TextField();
						absolute_desc.selectable = true;
						absolute_desc.borderColor = 0x000000;
						absolute_desc.border = true;
						absolute_desc.multiline = true;
						absolute_desc.height = domain.height/4;
						absolute_desc.width = 110;
						absolute_desc.background = false;
						absolute_desc.backgroundColor = 0xffffff;
						absolute_desc.type = TextFieldType.DYNAMIC;
						absolute_desc.restrict = "A-Z a-z 0-9";
						absolute_desc.maxChars = 30;
						this.addChild(absolute_desc);
						absolute_desc.x = domain.width + domain.x + j * absolute_desc.width;
						absolute_desc.y = domain.y;
						absolute_desc.htmlText = "absolute:";
						absolute_desc.setTextFormat(format);
						
						var relative_desc:TextField = new TextField();
						relative_desc.selectable = true;
						relative_desc.borderColor = 0x000000;
						relative_desc.border = true;
						relative_desc.multiline = true;
						relative_desc.height = domain.height/4;
						relative_desc.width = absolute_desc.width;
						relative_desc.background = false;
						relative_desc.backgroundColor = 0xffffff;
						relative_desc.type = TextFieldType.DYNAMIC;
						relative_desc.restrict = "A-Z a-z 0-9";
						relative_desc.maxChars = 30;
						this.addChild(relative_desc);
						relative_desc.x = domain.width + domain.x + j * relative_desc.width;
						relative_desc.y = domain.y + absolute_desc.height;
						relative_desc.htmlText = "relative:";
						relative_desc.setTextFormat(format);
						
						var intrasite_share_desc:TextField = new TextField();
						intrasite_share_desc.selectable = true;
						intrasite_share_desc.borderColor = 0x000000;
						intrasite_share_desc.border = true;
						intrasite_share_desc.multiline = true;
						intrasite_share_desc.height = domain.height/4;
						intrasite_share_desc.width = absolute_desc.width;
						intrasite_share_desc.background = false;
						intrasite_share_desc.backgroundColor = 0xffffff;
						intrasite_share_desc.type = TextFieldType.DYNAMIC;
						intrasite_share_desc.restrict = "A-Z a-z 0-9";
						intrasite_share_desc.maxChars = 30;
						this.addChild(intrasite_share_desc);
						intrasite_share_desc.x = domain.width + domain.x + j * absolute_desc.width;
						intrasite_share_desc.y = domain.y + absolute_desc.height*2;
						intrasite_share_desc.htmlText = "intrasite share:";
						intrasite_share_desc.setTextFormat(format);
						
						var intraphrase_share_desc:TextField = new TextField();
						intraphrase_share_desc.selectable = true;
						intraphrase_share_desc.borderColor = 0x000000;
						intraphrase_share_desc.border = true;
						intraphrase_share_desc.multiline = true;
						intraphrase_share_desc.height = domain.height/4;
						intraphrase_share_desc.width = absolute_desc.width;
						intraphrase_share_desc.background = false;
						intraphrase_share_desc.backgroundColor = 0xffffff;
						intraphrase_share_desc.type = TextFieldType.DYNAMIC;
						intraphrase_share_desc.restrict = "A-Z a-z 0-9";
						intraphrase_share_desc.maxChars = 30;
						this.addChild(intraphrase_share_desc);
						intraphrase_share_desc.x = domain.width + domain.x + j * absolute_desc.width;
						intraphrase_share_desc.y = domain.y + absolute_desc.height*3;
						intraphrase_share_desc.htmlText = "intraphrase share:";
						intraphrase_share_desc.setTextFormat(format);
					}
					
					var absolute:TextField = new TextField();
					absolute.selectable = true;
					absolute.borderColor = 0x000000;
					absolute.border = true;
					absolute.multiline = true;
					absolute.height = domain.height/4;
					absolute.width = 80;
					absolute.background = false;
					absolute.backgroundColor = 0xffffff;
					absolute.type = TextFieldType.DYNAMIC;
					absolute.restrict = "A-Z a-z 0-9";
					absolute.maxChars = 30;
					this.addChild(absolute);
					absolute.x = 110 + domain.width + domain.x + j * absolute.width;
					absolute.y = domain.y;
					absolute.htmlText = String(t[i][j+1]);
					absolute.setTextFormat(format);
					
					var relative_num:Number = 0;
					relative_num = t[i][j + 1] / t[i][0];
					relative_num = Math.round(relative_num * 10000) / 100;
					
					var relative:TextField = new TextField();
					relative.selectable = true;
					relative.borderColor = 0x000000;
					relative.border = true;
					relative.multiline = true;
					relative.height = domain.height/4;
					relative.width = absolute.width;
					relative.background = false;
					relative.backgroundColor = 0xffffff;
					relative.type = TextFieldType.DYNAMIC;
					relative.restrict = "A-Z a-z 0-9";
					relative.maxChars = 30;
					this.addChild(relative);
					relative.x = 110 + domain.width + domain.x + j * absolute.width;
					relative.y = domain.y + absolute.height;
					relative.htmlText = String(relative_num) + "%";
					relative.setTextFormat(format);
					
					var intrasiteshare:Number = 0;
					for (var k:Number = 0; k < f[2].length; k++)
					{
						intrasiteshare += (t[i][k+1]);
					}
					intrasiteshare = t[i][j + 1] / intrasiteshare;
					intrasiteshare = Math.round(intrasiteshare * 10000) / 100;
					
					var intrasite_share:TextField = new TextField();
					intrasite_share.selectable = true;
					intrasite_share.borderColor = 0x000000;
					intrasite_share.border = true;
					intrasite_share.multiline = true;
					intrasite_share.height = domain.height/4;
					intrasite_share.width = absolute.width;
					intrasite_share.background = false;
					intrasite_share.backgroundColor = 0xffffff;
					intrasite_share.type = TextFieldType.DYNAMIC;
					intrasite_share.restrict = "A-Z a-z 0-9";
					intrasite_share.maxChars = 30;
					this.addChild(intrasite_share);
					intrasite_share.x = 110 + domain.width + domain.x + j * absolute.width;
					intrasite_share.y = domain.y + absolute.height * 2;
					intrasite_share.htmlText = String(intrasiteshare) + "%";
					intrasite_share.setTextFormat(format);
					
					var intraphraseshare:Number = 0;
					for (var h:Number = 0; h < f[1].length; h++)
					{
						intraphraseshare += (t[h][j+1])/t[h][0];
					}
					intraphraseshare = (t[i][j + 1]/t[i][0]) / intraphraseshare;
					intraphraseshare = Math.round(intraphraseshare * 10000) / 100;
					
					var intraphrase_share:TextField = new TextField();
					intraphrase_share.selectable = true;
					intraphrase_share.borderColor = 0x000000;
					intraphrase_share.border = true;
					intraphrase_share.multiline = true;
					intraphrase_share.height = domain.height/4;
					intraphrase_share.width = absolute.width;
					intraphrase_share.background = false;
					intraphrase_share.backgroundColor = 0xffffff;
					intraphrase_share.type = TextFieldType.DYNAMIC;
					intraphrase_share.restrict = "A-Z a-z 0-9";
					intraphrase_share.maxChars = 30;
					this.addChild(intraphrase_share);
					intraphrase_share.x = 110 + domain.width + domain.x + j * absolute.width;
					intraphrase_share.y = domain.y + absolute.height * 3;
					intraphrase_share.htmlText = String(intraphraseshare) + "%";
					intraphrase_share.setTextFormat(format);
				}
			}
			
			var description5:TextField = new TextField();
			description5.selectable = false;
			description5.text = "COPY TO CLIPBOARD";
			description5.borderColor = 0x000000;
			description5.border = false;
			description5.multiline = false;
			description5.height = 20;
			description5.width = 180;
			description5.type = TextFieldType.DYNAMIC;
			description5.restrict = "A-Z a-z 0-9";
			description5.setTextFormat(format);
			description5.maxChars = 30;
			this.addChild(description5);
			description5.x = 20;
			description5.y = 15;
			
			var up:Sprite = new Sprite();
			up.graphics.beginFill(0x00ff00, 0.4);
			up.graphics.lineStyle(1, 0x000000, 1);
			up.graphics.drawRoundRect(1, 1, 190, 20, 0, 0);
			var over:Sprite = new Sprite();
			over.graphics.beginFill(0x55ff00, 0.4);
			over.graphics.lineStyle(1, 0x000000, 1);
			over.graphics.drawRoundRect(1, 1, 190, 20, 0, 0);
			var down:Sprite = new Sprite();
			down.graphics.beginFill(0x00ff00, 0.4);
			down.graphics.lineStyle(1, 0x000000, 1);
			down.graphics.drawRoundRect(1, 1, 190, 20, 0, 0);
			
			button = new SimpleButton(up, over, down,over);
			this.addChild(button);
			button.x = 10;
			button.y = 15;
			
		}
		public function csv_construct(t:Array,f:Array):void
		{
			//CSV Construction -------------------------------------------------------------------------------------------------------------------------
			var csv_1:Array = new Array();
			csv_1.push(String(",,"));
			for (var i:Number = 0; i < f[1].length; i++)
			{
				csv_1.push(String(","));
				csv_1.push(String(f[1][i]+","));
				csv_1.push(String(t[i][0]+","));
				csv_1.push(String(","));
				//domain.htmlText = "<br>." + f[1][i] + "<br>" + String(t[i][0]);
				
				for (var j:Number = 0; j < f[2].length; j++)
				{
					if (i == 0)
					{
						csv_1[0] = csv_1[0] + String(f[2][j]) + ",";
						//phrase.htmlText = String(f[2][j]);
					}
					if (j == 0)
					{
						//absolute_desc.htmlText = "absolute:";
						csv_1[i * 4 + 1] += "absolute"+ ",";
						//relative_desc.htmlText = "relative:";
						csv_1[i * 4 + 2] += "relative"+ ",";
						//intrasite_share_desc.htmlText = "intrasite share:";
						csv_1[i * 4 + 3] += "intrasite share"+ ",";
						//intraphrase_share_desc.htmlText = "intraphrase share:";
						csv_1[i * 4 + 4] += "intraphrase share"+ ",";
					}
					//absolute.htmlText = String(t[i][j+1]);
					csv_1[i * 4 + 1] += String(t[i][j+1]) + ",";
					var relative_num:Number = 0;
					relative_num = t[i][j + 1] / t[i][0];
					relative_num = Math.round(relative_num * 10000) / 100;
					//relative.htmlText = String(relative_num) + "%";
					csv_1[i * 4 + 2] += String(relative_num) + "%" + ",";
					var intrasiteshare:Number = 0;
					for (var k:Number = 0; k < f[2].length; k++)
					{
						intrasiteshare += (t[i][k+1]);
					}
					intrasiteshare = t[i][j + 1] / intrasiteshare;
					intrasiteshare = Math.round(intrasiteshare * 10000) / 100;
					//intrasite_share.htmlText = String(intrasiteshare) + "%";
					csv_1[i * 4 + 3] += String(intrasiteshare) + "%" + ",";
					var intraphraseshare:Number = 0;
					for (var h:Number = 0; h < f[1].length; h++)
					{
						intraphraseshare += (t[h][j+1])/t[h][0];
					}
					intraphraseshare = (t[i][j + 1]/t[i][0]) / intraphraseshare;
					intraphraseshare = Math.round(intraphraseshare * 10000) / 100;
					//intraphrase_share.htmlText = String(intraphraseshare) + "%";
					csv_1[i * 4 + 4] += String(intraphraseshare) + "%" + ",";
				}
			}
			for (var l:Number = 0; l < csv_1.length; l++)
			{
			csv = csv + csv_1[l] + "\n";
			}
		}
	}
	
}