% Zeitintervall und Startwert:
t0 = 0;
T = 0.2;
y0 = pi;

% Parameter fuer rechte Seite:
k = -1e-1;

% Rechte Seite:
f = @(t,y) k*y;

% Schrittweitenfolge erzeugen:
h = 0.2*0.5.^(0:12);
errors = zeros(size(h));

% 1. Rechnen in double precision

% Schleife ueber die Schrittweiten
for i=1:length(h)
   % Loesen des AWPs
   y = ExpliziterEuler(f, t0, T, h(i), y0, [], 'd'); 
   % Berechnen des Fehlers zum Endzeitpunkt T
   errors(i) = abs(y(2,end) - pi*exp(k*T));
end

% Grafische Ausgabe der Fehler
figure('Name', 'Fehler bei Rechnung mit double precision')
loglog(h, errors)

% Schaetzen der Konvergenzordnung
p = eoc(h', errors');
fprintf('Geschaetzte Konvergenzordnung: p=%1.6f.\n', p)


% 2. Rechnen in single precision

for i=1:length(h)
   % Loesen des AWPs
   y = ExpliziterEuler(f, t0, T, h(i), y0, [], 's'); 
   % Berechnen des Fehlers zum Endzeitpunkt T
   errors(i) = abs(y(2,end) - pi*exp(k*T));
end

% Grafische Ausgabe der Fehler
figure('Name', 'Fehler bei Rechnung mit single precision')
loglog(h, errors)

% Schaetzen der Konvergenzordnung
p = eoc(h', errors');
fprintf('Geschaetzte Konvergenzordnung: p=%1.6f.\n', p)
