function [y, nNewton] = implMidpointTS(f, t0, T, h, y0, nmax, TOL,epsi,A)

% y initialisieren
y = zeros(length(y0)+1,2);

% Den Startwert kennen wir schon
y(1,1) = t0;
y(2:end,1) = y0;

nNewton = zeros(1,size(y,2)-1);
%% Schleife ueber alle Zeitschritte:
time = 0;
hi = h;
i=1;
rho = 0.9;
p = 2;
while y(1,i)<T
    % Zeitpunkt aktualisieren:
    % (Durch Rundungsfehler koennte man ueber
    % T hinausschiessen, das wird hier abgefragt.)    
    %% Method for big step h
    k = zeros(size(y(2:end,i)));
    % Auswerten der Funktion und ihrer Ableitung
    [F,DF] = feval(f,y(1,i)+hi/2, y(2:end,i)+hi/2*k,A,epsi);
    % Das Residuum
    Fz = k- F;
    nNewton = 0;
    while (norm(Fz) > 1e-6 || nNewton < 1) && nNewton < nmax
        % Lösen der Newton-Gleichung
        dk = -(eye(size(k,1)) - hi/2*DF)\Fz;
        % Update
        k = k + dk;
        % Alles wieder von vorne
        [F,DF] = feval(f,y(1,i)+hi/2, y(2:end,i)+hi/2*k,A,epsi);
        Fz = k- F;
        nNewton = nNewton +1;
    end
    yh1 = y(2:end,i)+hi*k;
    %% Method for two half-steps h/2
    hii=hi/2;
    % Step 1
    k = zeros(size(y(2:end,i)));
    % Auswerten der Funktion und ihrer Ableitung
    [F,DF] = feval(f,y(1,i)+hii/2, y(2:end,i)+hii/2*k,A,epsi);
    % Das Residuum
    Fz = k- F;
    nNewton = 0;
    while (norm(Fz) > 1e-6 || nNewton < 1) && nNewton < nmax
        % Lösen der Newton-Gleichung
        dk = -(eye(size(k,1)) - hii/2*DF)\Fz;
        % Update
        k = k + dk;
        % Alles wieder von vorne
        [F,DF] = feval(f,y(1,i)+hii/2, y(2:end,i)+hii/2*k,A,epsi);
        Fz = k- F;
        nNewton = nNewton +1;
    end
    yh2 = y(2:end,i)+hii*k;
    % Step 1
    k = zeros(size(y(2:end,i)));
    % Auswerten der Funktion und ihrer Ableitung
    [F,DF] = feval(f,y(1,i)+hii, yh2+hii/2*k,A,epsi);
    % Das Residuum
    Fz = k- F;
    nNewton = 0;
    while (norm(Fz) > 1e-6 || nNewton < 1) && nNewton < nmax
        % Lösen der Newton-Gleichung
        dk = -(eye(size(k,1)) - hii/2*DF)\Fz;
        % Update
        k = k + dk;
        % Alles wieder von vorne
        [F,DF] = feval(f,y(1,i)+hii/2, yh2+hii/2*k,A,epsi);
        Fz = k- F;
        nNewton = nNewton +1;
    end
    yh2 = yh2+hii*k;
    
    % Estimate
    EST= norm(yh2-yh1)/(2^p-1);
    hs = hi*(rho*TOL/EST)^(1/(p+1));
    if EST<TOL
        y(1,i+1) = y(1,i)+hi;
        disp(y(1,i+1))
        y(2:end,i+1) = yh1;   
        hi = min(hs,T-y(1,i))
        i = i+1;
    else
        hi = hs;
    end
    if i==500
        break
    end
end
