% Solving 2D Allen-Cahn Eq using pseudo-spectral with Implicit/Explicit
% u_t= (u_{xx}+u_{yy}) +epsilon^-2 (u - u^3)
% BC = Periodic
% IC=v=sin(2*pi*x)+0.001*cos(16*pi*x;
clear all; 
close all

%Grid
n = 32; % grid points in space
hx = 1/(n); % mesh size
n2 = n^2; % degrees of freedom
t0 = 0; % start time
T = 1/10; % final time
%% initial conditions
y0x = (rand(n,n)-0.5)*0.1;

%% Parameters
epsi=.025;

%% Laplacian
e = ones(n,1); % One Vector
Dx = spdiags([-e 2*e -e], -1:1, n, n); % 1D finite difference matrix
I = speye(n);
% Apply Neumann boundary in 1D
Dx(1,1) = 1; Dx(1,2) = -1;
Dx(end,end) = 1; Dx(end,end-1) = -1;
A = -1/(hx^2)*(kron(I,Dx)+kron(Dx,I));

%% Time Intervall
tspan = [t0 T];

%% THIS IS QUESTION A)
%% Prepare the ODE Solver
options = odeset('Jacobian',@(t,y)Jacobi(t,y,A,epsi)); % Define the Jacobi Function. WRITE IT!
options = odeset('RelTol',1e-6,'AbsTol',1e-8);
options = odeset('Stats','on'); % Get more info

%% Call a stiff ODE Solver
[t,y] = ode15s(@(t,y) RHS_AllenCahn(t,y,A,epsi), tspan, y0x(:),options); % WRITE RHS_AllenCahn!
% 
%% Plot the Solution
nt = size(t);
for i =1:nt
    subplot(1,2,1)
    pcolor(reshape(y(i,:),n,n))
    subplot(1,2,2)
    semilogy(t)
    pause(.01)
end

%% THIS IS QUESTION B)
%% The implicit midpoint rule, no time-stepping
h =1/10000; % We need a small step-size as the system is quite stiff, remember the Laplacian is involved
method = 'newton'; % We use the Newton method but you could also use the simplified Newton
nmax = 5;
f = @RHS_AllenCahn2; % This function returns also the Jacobian, you could also use the functions from Question A) WRITE IT!
[yh, nNewton] = implMidpoint(f, t0, T, h, y0x(:), nmax, method,epsi,A);  % Change the function from last time WRITE IT!

%% THIS IS QUESTION C)
%% The adaptive implicit midpoint rule
h =1e-5; % Initial step-size
method = 'newton';
nmax = 10;
TOL = 1e-3;
f = @RHS_AllenCahn2;
[yh, nNewton] = implMidpointTS(f, t0, T, h, y0x(:), nmax, TOL,epsi,A); % Change the function from Question B and compute hs.
%% Plot the Solution
% nt = size(t);
for i =1:size(yh,2)
    pcolor(reshape(yh(2:end,i),n,n))
    pause(.01)
end

