function [x, iter, resNorm] = myCG_jacobi(A, b, maxIter, tolerance, numJacobiIter)

    if nargin < 3
        maxIter = 100;
    end
    if nargin < 4
        tolerance = 1e-8;
    end
    if nargin < 5
        numJacobiIter = 5;
    end
    
    D = diag(diag(A));

    x = rand(size(b));
    r = A*x - b;
    w = applyPreconditioner(A, D, r, numJacobiIter);
    q = w;

    for iter = 1:maxIter
        Aq = A*q;
        r_old = r;
        w_old = w;
        
        alpha = - (r'*w)/(q'*Aq);
        x = x + alpha*q;
        r = r + alpha*Aq;
        
        resNorm = norm(r);
        if resNorm < tolerance
            break;
        end
        
        w = applyPreconditioner(A, D, r, numJacobiIter);
        beta = (r'*w) / (r_old'*w_old);
        q = w + beta*q;
    end

    
end

function w = applyPreconditioner(A, D, r, numJacobiIter)
    w = zeros(size(r));
    for iter = 1:numJacobiIter
        w = w + D \ (r - A*w);
    end
end