function [x, iter, resNorm] = myCG(A, b, M, maxIter, tolerance)

    % If M = [] is passed or no M is passed at all, we set it to the
    % (sparse) identity
    if nargin < 3 || isempty(M)
        M = speye(size(A));
    end
    if nargin < 4
        maxIter = 100;
    end
    if nargin < 5
        tolerance = 1e-8;
    end

    x = rand(size(b));
    r = A*x - b;
    w = M \ r;
    q = w;

    for iter = 1:maxIter
        Aq = A*q;
        r_old = r;
        w_old = w;
        
        alpha = - (r'*w)/(q'*Aq);
        x = x + alpha*q;
        r = r + alpha*Aq;
        
        resNorm = norm(r);
        if resNorm < tolerance
            break;
        end
        
        w = M \ r;
        beta = (r'*w) / (r_old'*w_old);
        q = w + beta*q;
    end

    
end