function p = lagrange(x, y)

    V = vander(x);
    % Oder alternativ V = x(:) .^ (length(x)-1:-1:0);
    p = V \ y(:);

    % Alternativ kann man auch die Vandermonde-Matrix erst so aufstellen,
    % wie wir es vorher in der Vorlesung hatten:
    % V = x(:) .^ (0:length(x)-1);
    % und dann später die Reihenfolge in p ändern:
    % p = p(end:-1:1);
end

