
p = 400;
A = gallery('poisson', p);
n = size(A, 1);

%b = full(sum(A, 2));
b = rand(n, 1);

maxIter = 10000;
tolerance = 1e-12;

fprintf('Running CG method on matrix with n=%d (p=%d), maxIter=%d, tolerance=%g\n', n, p, maxIter, tolerance);


%% CG without preconditioning

M = speye(size(A));

tic;
[x, iter, resNorm] = myCG(A, b, M, maxIter, tolerance);
runTime = toc;

fprintf('- No preconditioning: Iter %d, time %gs, computed res norm %.4e, true res norm %.4e\n', ...
    iter, runTime, resNorm, norm(A*x - b));


%% CG with diagonal preconditioning

M = diag(diag(A));

tic;
[x, iter, resNorm] = myCG(A, b, M, maxIter, tolerance);
runTime = toc;

fprintf('- Diagonal preconditioning: Iter %d, time %gs, computed res norm %.4e, true res norm %.4e\n', ...
    iter, runTime, resNorm, norm(A*x - b));


%% CG with Jacobi preconditioning

numJacobiIter = 5;

tic;
[x, iter, resNorm] = myCG_jacobi(A, b, maxIter, tolerance, numJacobiIter);
runTime = toc;

fprintf('- Jacobi preconditioning: Iter %d, time %gs, computed res norm %.4e, true res norm %.4e\n', ...
    iter, runTime, resNorm, norm(A*x - b));
