

f = @(x) 1./(1 + 25*x.^2);

n = 4;

%% Equidistant points

xEqui = linspace(-1, 1, n+1);
yEqui = f(xEqui);

pEqui = lagrange(xEqui, yEqui);

%% Chebyshev points

xCheby = cos(((0:n) + 1/2)*pi/(n+1));
yCheby = f(xCheby);

pCheby = lagrange(xCheby, yCheby);

%% Plot results

xPlot = linspace(-1.1, 1.1, 1000);

figure;
markerSize=15;

plot(xPlot, f(xPlot), '--k');
hold('on');

plot(xEqui, yEqui, 'xb', 'MarkerSize', markerSize);
plot(xPlot, polyval(pEqui, xPlot), '-b');

plot(xCheby, yCheby, 'or', 'MarkerSize', markerSize);
plot(xPlot, polyval(pCheby, xPlot), '-r');

title(sprintf('Runge function interpolation, n=%d', n))
%legend('Reference', 'Equidistant knots', 'Equidistant interpolation', 'Chebyshev knots', 'Chebyshev interpolation');
ylim([-0.5, 1.5]);