data = [
    1990 49774
    1991 31341
    1992 25298
    1993 23423
    1994 22734
    1995 24004
    1996 27006
    1997 29008
    1998 30190
    1999 31383
    2000 33139
    2001 31943
    2002 31518
    2003 32079
    2004 33044
    2005 32581
    2006 32556
    2007 33858
    2008 34411
    2009 34093
    2010 35091
    2011 34423
    2012 34686
    2013 34800
    2014 35935
    2015 36466
    2016 37941
];

x = data(1:3:end, 1) - 1989;
y = data(1:3:end, 2);

p = lagrange(x, y);

xPlot = linspace(1990, 2016, 100);
yPlot = polyval(p, xPlot-1989);

yTrue2012 = data(2012-1989, 2);
yInterp2012 = polyval(p, 2012-1989);
fprintf('Year 2012: true value %d, interpolated value %.2f, relative error %.4f%%\n', ...
    yTrue2012, ...
    yInterp2012, ...
    100*abs(yTrue2012 - yInterp2012)/yTrue2012);

yTrue2016 = data(2016-1989, 2);
yInterp2016 = polyval(p, 2016-1989);
fprintf('Year 2016: true value %d, interpolated value %.2f, relative error %.4f%%\n', ...
    yTrue2016, ...
    yInterp2016, ...
    100*abs(yTrue2016 - yInterp2016)/yTrue2016);

figure;
plot(xPlot, yPlot, '-b', ...
    data(:,1), data(:,2), 'xr', ...
    data(1:3:end,1), data(1:3:end,2), 'or', ...
    'MarkerSize', 25);
ylim([0, 55000])