
function L = myChol(A)
% Compute the Cholesky decomposition of a sparse s.p.d. matrix A. The 
% result is a sparse lower triangular matrix.

    n = size(A, 1);
    L = sparse(n,n);
    for i = 1:n
        L(i,i) = sqrt(A(i,i) - L(i, 1:i-1)*L(i, 1:i-1)');
        L(i+1:n, i) = 1/L(i,i) * (A(i+1:n, i) - L(i+1:n, 1:i-1)*L(i, 1:i-1)');
    end
end