

%% Setup

p = 100;
N = 30000;
alpha = 0.01;
method = 2;

A = gallery('poisson', p);
b = sum(A, 2);

%% Test methods

tic;
if method == 1
    x = richardsonMethod(A, b, alpha, N);
elseif method == 2
    x = jacobiMethod(A, b, N);
else
    x = gaussSeidelMethod(A, b, N);
end
t = toc;

%% Print results

methodNames = {sprintf('Richardson (alpha=%g)', alpha), 'Jacobi', 'Gauss-Seidel'};
fprintf('Results of %s with p=%d and N=%d: runtime %gs, residual %.4e\n', methodNames{method}, p, N, t, norm(A*x-b));

