
%% Load matrix
A = gallery('poisson', 30);

%% Run own Cholesky decomposition
myL = myChol(A);

cholError = norm(A - myL*myL', 1);
fprintf('Residual matrix norm: %.4e\n', cholError);

%% Run chol
L = chol(A, 'lower');

figure;
spy(L);

%% Run amd + chol

p = amd(A);
Lp = chol(A(p,p), 'lower');

figure;
spy(Lp);

