function G = givensrot(x, i, k)

    if abs(x(i)) < 1e-12
        c = 0;
        s = 1;
    else
        r = x(k)/x(i);
        c = 1 / sqrt(1 + r^2);
        s = r * c;
    end
    
    G = eye(length(x));
    G(i,i) = c;
    G(i,k) = s;
    G(k,i) = -s;
    G(k,k) = c;
end