function y = approxExp_stabilized(x, l)
% Approximate exp(x) by the first l elements of the series representation,
% stabilized to avoid large errors for negative x
    if x >= 0
        y = approxExp(x, l);
    else
        y = 1 / approxExp(-x, l);
    end
end