
nl = 30;

% Setup 30 values for l between 10^0 and 10^4
% (exponents equidistantly distributed)
l = round(logspace(0,4,nl));

figure;

for x = [-100, -10, -1, 1, 10, 100]
    errors = zeros(1, nl);
    
    for i = 1:nl
        %y = approxExp(x, l(i));
        y = approxExp_stabilized(x, l(i));

        yTrue = exp(x);
        errors(i) = abs(y - yTrue)/yTrue;
    end
    
    loglog(l, errors);
    hold('on');
end

legend('x=-100', 'x=-10', 'x=-1', 'x=1', 'x=10', 'x=100')
xlabel('l (number of series elements)');
ylabel('Relative Error');
