function [Unew,Vnew]=trunc(U,V,trunctol)
% %% QR BASED
% % [UU,SS,VV,flag] = mysvds(U,V,size(U,1),size(V,1));
% [QU,RU] = qr(U,0);
% [QV,RV] = qr(V,0);
% 
% [US,S,VS]=svd(full(RU*RV'));
% 
% if (norm(diag(S))<1e-10)
%     Unew=sparse(size(U,1),1);
%     Vnew=sparse(size(V,1),1);
% else
%     d=diag(S)./S(1,1);
%     index=find(d>trunctol);
%     d2 = diag(S)';
%     Unew=QU*US(:,index)*sqrt(diag(d2(index)));    
%     Vnew=QV*VS(:,index)*sqrt(diag(d2(index)));
% end

%% SVDS based
[QU,SU,RU,flag] = mysvds(U,V,size(U,1),size(V,1));
if (norm(diag(SU))<1e-10)
    Unew=sparse(size(U,1),1);
    Vnew=sparse(size(V,1),1);
else    
    du=diag(SU)./SU(1,1);
    indexu=find(du>trunctol);
    du2 = diag(SU)';
    Unew = QU(:,indexu)*SU(indexu,indexu);
    Vnew = RU(:,indexu);
end


% %% SVDS based
% [QU,SU,RU] = svds(U,min(800,size(U,2)));
% [QV,SV,RV] = svds(V,min(800,size(V,2)));
% 
% if (norm(diag(SU))<1e-10)
%     Unew=sparse(size(U,1),1);
%     Vnew=sparse(size(V,1),1);
% else    
%     du=diag(SU)./SU(1,1);
%     indexu=find(du>trunctol);
%     du2 = diag(SU)';
%     dv=diag(SV)./SV(1,1);
%     indexv=find(dv>trunctol);
%     dv2 = diag(SV)';
%     indexu = 1:min(indexv(end),indexu(end));
%     Unew = QU(:,indexu)*SU(indexu,indexu);
%     Vnew = QV(:,indexu)*SV(indexu,indexu)*(RV(:,indexu))'*(RU(:,indexu));
% end

% %% More SVDS based
% [Q,S,R] = svds(@(x)truncprod(U,V));
% if (norm(diag(S))<1e-10)
%     Unew=sparse(size(U,1),2);
%     Vnew=sparse(size(V,1),2);
% else
%     d=diag(S)./S(1,1);
%     index=find(d>trunctol);
%     d2 = diag(S);
%     Unew=Q(:,index);    
%     Vnew=R(:,index)*(S(index,index));
% end

return
