function y=toep_mult_coeff_prob3(x,a,b,n,ap,am,tau);
% Perform the matrix multiplication with P_{+}T+P_{-}T'
% a is the first column of a Toeplitz matrix 
% b is the first row of a Toeplitz matrix

c=fft([a;[0 b(end:-1:1)]']);
w = [x(:);zeros(n,1)];
y1 = real( ifft( c .* fft(w) ) ); 
y1= y1(1:n);

% Multiplication with T
c=fft([[a(1),b]';[0 a(end:-1:2)']']);
w = [x(:);zeros(n,1)];
y2 = real( ifft( c .* fft(w) ) ); 
y2 = y2(1:n);

y=1/2*x-tau*(ap*y1+am*y2);

