function [X1,X2,res]=ikpik_mf_prob3_coeff(lA1,lA2,lB1,lB2,lCA,lCB,rhs1,rhs2,m,tol1,tol2,La,Ua,Lb,Ub,ap,am,bp,bm,tau)
%function [X1,X2]=accel_sylv_mrhs_explicit(A,LA,UA,B,LLB,UB,rhs1,rhs2,m,tol)
%
% KPIK algorithm for Sylvester equation  (extended Krylov subspace type method)
%
%   solve    A X + X B' = rhs1 rhs2'    (mind the transposition in B !!)
%                                       rhs1,rhs2 tall matrices
%  assume sep(A,B) >0
%  A = LA*UA;   LU factorization of A
%  B = LLB*UB;   LU factorization of B
%  (modify the corresponding lines in the code if solves with A and B are performed inexactly)
%  m = max space dimension, say min(sqrt(size(A)),sqrt(size(B)))
%  tol = max final accuracy (in terms of relative residual)
%
%  [X1,X2] = solution factors   X_approx = X1 X2'
%
% NOT FOR DISTRIBUTION. TEST VERSION
%

nrmb1=norm(rhs1,'fro');
nrmb2=norm(rhs2,'fro');


%nrma=norm(A,'fro');
%nrmb=norm(B,'fro');

[n,sh]=size(rhs1);
[nB,sh1]=size(rhs2); if sh~=sh1, fprintf('wrong rhs size\n');return;end


res0=norm(rhs1)*norm(rhs2);

odds=[];
oddsB=[];

%% Do this by hand here as CA is nonsymmetric and CB is not
kA_max = m;
kB_max =m ;
%kB_max =2 ;
% if norm(A-A',1)<1e-14, kA_max =2 ; else kA_max = m; end
% if norm(B-B',1)<1e-14, kB_max =2 ; else kB_max = m; end

s=2*sh;

% rhsA=UA\(LA\rhs1);
% rhsB=UB\(LLB\rhs2);

% Iterative solution
for i=1:size(rhs1,2)
    [rhsA(:,i),flag,relres,iter,resvec] = gmres(@(x)toep_mult_coeff_prob3(x,lA1,lA2',size(lA1,1),ap,am,tau),rhs1(:,i),[],tol2,min(size(lA1,1),100), @(x)prec_coeff(x,La,Ua));        
end

for i=1:size(rhs2,2)
    [rhsB(:,i),flag,relres,iter,resvec] = gmres(@(x)toep_mult_coeff_prob3(x,lB1,lB2',size(lB1,1),bp,bm,tau),rhs2(:,i),[],tol2,min(size(lB1,1),100), @(x)prec_coeff(x,Lb,Ub));        
end

UU=[rhs1, rhsA];
WW=[rhs2, rhsB];

% Sequence in A
[ibeta,U(:,1:s)]=mgs(UU);
H=sparse((m+1)*s,m*s); L=sparse((m+1)*s,m*s);
beta=inv(ibeta); beta = beta(1:sh,1:sh);

% Sequence in B'
[ibetaB,W(:,1:s)]=mgs(WW);
HB=sparse((m+1)*s,m*s); LB=sparse((m+1)*s,m*s);
betaB=inv(ibetaB); betaB = betaB(1:sh,1:sh);

beta2=beta*betaB';

% fprintf('      it        abs res F-norm\n')

for j=1:m,
    jms=(j-1)*s+1;j1s=(j+1)*s;js=j*s;js1=js+1; jsh=(j-1)*s+sh;
    
    % Sequence in A
    %     Up(:,1:sh) = A*U(:,jms:jsh);
    for i=1:s-sh
        Up(:,i)=toep_mult_coeff_prob3(U(:,jms+i-1),lA1,lA2',size(lA1,1),ap,am,tau);
    end
    %     Up(:,sh+1:s) = UA\(LA\U(:,jsh+1:js));
    for i=1:s-sh
%         [Up(:,sh+i),flag,relres,iter,resvec] = gmres(@(x)toep_mult(x,lA1,lA2',size(lA1,1)),U(:,jsh+i),[],tol2,min(size(lA1,1),50),@(x)circ_inv(x,lCA));
        [Up(:,sh+i),flag,relres,iter,resvec] = gmres(@(x)toep_mult_coeff_prob3(x,lA1,lA2',size(lA1,1),ap,am,tau),U(:,jsh+i),[],tol2,min(size(lA1,1),100), @(x)prec_coeff(x,La,Ua));    
        %                 [Up(:,sh+i),flag,relres,iter,resvec] = gmres(A,U(:,jsh+i),[],tol2,50,CA);
    end
    %   UU=[UU,Up];
    %new bases block (modified gram)
    for l=1:2
        k_min=max(1,j-kA_max);
        for kk=k_min:j
            k1=(kk-1)*s+1; k2=kk*s;
            coef= U(1:n,k1:k2)'*Up;
            H(k1:k2,jms:js) = H(k1:k2,jms:js)+ coef; % U(1:n,k1:k2)'*Up;
            Up = Up - U(:,k1:k2)*coef; %H(k1:k2,jms:js);
        end
    end
    if (j<=m)
        [hinv,U(1:n,js1:j1s)]=mgs(Up);
        %  H(js1:j1s,jms:js)=hinv\speye(size(hinv,1));
        H(js1:j1s,jms:js)=inv(hinv);
    end
    I=speye(js+s);
    %   if (j==1),
    %     L(1:j*s+sh,(j-1)*sh+1:j*sh) =...
    %     [ H(1:s+sh,1:sh)/ibeta(1:sh,1:sh), speye(s+sh,sh)/ibeta(1:sh,1:sh)]*ibeta(1:s,sh+1:s);
    %   else
    %     L(1:j*s+s,(j-1)*sh+1:j*sh) = L(1:j*s+s,(j-1)*sh+1:j*sh) + H(1:j*s+s,jms:jms-1+sh)*rho;
    %   end
    odds = [odds, jms:(jms-1+sh)];   % store the odd block columns
    evens = 1:js; evens(odds)=[];
    T(1:js+s,odds)=H(1:js+s,odds);   %odd columns
    AU(1:n,odds)=U(1:n,1:js+s)*H(1:js+s,odds);
    for i=1:js-jms-sh+1
        AU(:,jms+sh+i-1)=toep_mult_coeff_prob3(U(:,jms+sh+i-1),lA1,lA2',size(lA1,1),ap,am,tau);
        %AU(:,i)=toep_mult(U(:,jms+sh+i-1),lA1,lA2',size(lA1,1));
    end
    %   T(1:js+sh,jms+sh:js)=U(:,1:js+sh)'*(AU);
    T(1:j1s,js-s+1:js)=U(:,1:j1s)'*AU(:,js-s+1:js);
    T(js-s+1:j1s,1:js)=U(:,js-s+1:j1s)'*AU;
    %     return
    
    %   T(1:js+sh,evens)=L(1:js+sh,1:j*sh);   %even columns
    %   L(1:j*s+s,j*sh+1:(j+1)*sh) = ...
    %      ( I(1:j*s+s,(js-sh+1):js)- T(1:js+s,1:js)*H(1:js,js-sh+1:js))*hinv(sh+1:s,sh+1:s);
    %   rho = hinv(1:sh,1:sh)\hinv(1:sh,sh+1:s);
    
    %Sequence in B'
    for i=1:s-sh
        Wp(:,i)=toep_mult_coeff_prob3(W(:,jms+i-1),lB1,lB2',size(lB1,1),bp,bm,tau);
    end
    %     Wp(:,sh+1:s) = UB\(LLB\W(:,jsh+1:js));
    for i=1:s-sh
        [Wp(:,sh+i),flag,relres,iter,resvec] = gmres(@(x)toep_mult_coeff_prob3(x,lB1,lB2',size(lB1,1),bp,bm,tau),W(:,jsh+i),[],tol2,min(size(lB1,1),100), @(x)prec_coeff(x,Lb,Ub));
    end
    %WW=[WW,Wp];
    %new bases block (modified gram)
    for l=1:2
        k_min=max(1,j-kB_max);
        for kk=k_min:j
            k1=(kk-1)*s+1; k2=kk*s;
            coef= W(1:nB,k1:k2)'*Wp;
            HB(k1:k2,jms:js) = HB(k1:k2,jms:js)+ coef;
            Wp = Wp - W(:,k1:k2)*coef;
        end
    end
    if (j<=m)
        [hinvB,W(1:nB,js1:j1s)]=mgs(Wp);
        %HB(js1:j1s,jms:js)=hinvB\speye(size(hinvB,1));
        HB(js1:j1s,jms:js)=inv(hinvB);
    end
    I=speye(js+s);
    % if (j==1),
    %   LB(1:j*s+sh,(j-1)*sh+1:j*sh) =...
    %   [ HB(1:s+sh,1:sh)/ibetaB(1:sh,1:sh), speye(s+sh,sh)/ibetaB(1:sh,1:sh)]*ibetaB(1:s,sh+1:s);
    % else
    %   LB(1:j*s+s,(j-1)*sh+1:j*sh) = LB(1:j*s+s,(j-1)*sh+1:j*sh) + HB(1:j*s+s,jms:jms-1+sh)*rhoB;
    % end
    oddsB = [oddsB, jms:(jms-1+sh)];   % store the odd block columns
    evens = 1:js; evens(oddsB)=[];
    TB(1:js+s,oddsB)=HB(1:js+s,oddsB);   %odd columns
    BW(:,oddsB)=W(:,1:js+s)*HB(1:js+s,oddsB);
    for i=1:js-jms-sh+1
        BW(1:nB,jms+sh+i-1)=toep_mult_coeff_prob3(W(:,jms+sh+i-1),lB1,lB2',size(lB1,1),bp,bm,tau);
        %   BW(:,i)=toep_mult(W(:,jms+sh+i-1),lB1,lB2',size(lB1,1));
    end
    TB(1:j1s,js-s+1:js)=W(:,1:j1s)'*BW(:,js-s+1:js);
    TB(js-s+1:j1s,1:js)=W(:,js-s+1:j1s)'*BW;
    
    %TB(1:js+sh,jms+sh:js)=W(:,1:js+sh)'*(BW);
    %TB(1:js+sh,evens)=LB(1:js+sh,1:j*sh);   %even columns
    %LB(1:j*s+s,j*sh+1:(j+1)*sh) = ...
    %   ( I(1:j*s+s,(js-sh+1):js)- TB(1:js+s,1:js)*HB(1:js,js-sh+1:js))*hinvB(sh+1:s,sh+1:s);
    %rhoB = hinvB(1:sh,1:sh)\hinvB(1:sh,sh+1:s);
    
    I = speye(j*s);
    k=j;
    
    % Solve reduced dim sylvester eqn
    %     Y = lyap2(full(T(1:js,1:js)),full(TB(1:js,1:js))',speye(k*s,sh)*beta2*speye(k*s,sh)'); % Version for people without the control toolbox
    Y = lyap_val(full(T(1:js,1:js)),full(TB(1:js,1:js))',speye(k*s,sh)*beta2*speye(k*s,sh)');
    
    %   cc = [H(js1:j1s,js-s+1:js-sh), T(js1:j1s,js-sh+1:js)];
    %cc = [H(js1:j1s,js-s+1:js-sh), L(js1:j1s,(j-1)*sh+1:j*sh)];
    %   ccB = [HB(js1:j1s,js-s+1:js-sh), TB(js1:j1s,js-sh+1:js)];
    % ccB = [HB(js1:j1s,js-s+1:js-sh), LB(js1:j1s,(j-1)*sh+1:j*sh)];
    % nrmx=norm(Y,'fro');
    % res(k)=sqrt(norm(cc*Y(js-s+1:js,:),'fro')^2+norm(Y(:,js-s+1:js)*ccB','fro')^2);
    %   res(k)=sqrt(norm(cc*Y(js-s+1:js,:),'fro')^2+norm(Y(:,js-s+1:js)*ccB','fro')^2)/res0;
    [qqA,rrA]=qr(AU-U(1:n,1:js)*T(1:js,1:js),0);
    RR=[eye(js),T(1:js,1:js);zeros(js),rrA];
    [qqB,rrB]=qr(BW-W(1:nB,1:js)*TB(1:js,1:js),0);
    RRB=[eye(js),TB(1:js,1:js);zeros(js),rrB];
    res(k)=norm(RR*[speye(k*s,sh)*beta2*speye(k*s,sh)' Y; Y zeros(js,js)]*RRB','fro')/res0;
    
    
    % True abs residual norm
    %   X=U(1:n,1:js)*Y*W(1:nB,1:js)';
    %   norm(A*X+X*B'+rhs1*rhs2','fro')
    %trueres=norm( AU(:,1:js)*Y*W(:,1:js)'+U(:,1:js)*Y*BW(:,1:js)'+rhs1*rhs2','fro')/res0
    
    
    %disp([k,res(k)])
    %             fprintf('      it        abs res F-norm\n')
    fprintf('   its           comp.res.   space dim.  rhs rank  \n')
    disp([k,res(j),js,s])
    if (res(k)<tol1), break, end % We want a fixed number of steps
end
X1=U(1:n,1:js)*Y; X2=W(1:nB,1:js);



return



function [u,q]=mgs(a)
%==================================================
% =============== a = q*inv(u) ====================
%==================================================
[q,u]=qr(a,0);
u=u\speye(size(u,1));
% u=inv(u);
return
