clear all;
close all;
%% This is a proof-of-concept implementation of the method introduced in 
%
% A low-rank in time approach to PDE-constrained optimization, 
% M Stoll, T Breiten, SIAM Journal on Scientific Computing, 2015
%
%
% This is the implementation of a distributed control problem. Here
% M1=M2=N=M (mass matrix). 
%
%
% The employed preconditioner uses kpik a method introduced by Valeria
% Simoncini and co-authors, please see her website. 
%
% This method relies on the lyap function to be available.
% 
% Our implementation is not sophisticated at this point but rather
% illustrates the method. More improvements are to be made and
% contributions are welcome.
%
%
% Martin Stoll and Tobias Breiten 2015

% A set of example data. Please use your own!
load Mybar_5_100.dat % A desired state
load M_5_100.dat % A mass matrix
load K_5_100.dat % A stiffness matrix
load ind_5_100.dat; % Something to plot the dealii data, typically not necessary

K=spconvert(K_5_100); % stiffness matrix
M=spconvert(M_5_100); % mass matrix

r1 = spconvert(Mybar_5_100)'; % desired state

Mb=M; % The control matrix could be boundary control or other
N=M; % The matrix representing the control in the state equation

nt = 20; % number of time-steps
r1 = r1(:,1:nt);

n = size(M,1); % Matrix size, dimension of spatial discretization
nb = size(Mb,1); % Matrix size, dimension of spatial discretization nb=n


tau =1/nt;
beta = 1e-4; % Regularization parameters

rhs1 = reshape(r1,n*nt,1);
I = speye(nt);

% Temporal discretization
e=ones(nt,1);
C=spdiags([-e e],-1:0,nt,nt); % C matrix representing the implicit Euler discretization
r3 = sparse(n,nt); % Right hand side for PDE part with zero initial condition and zero-Dirichlet condition/

tol = 1e-6; % it solver tolerance
trunctol = 1e-10; % truncation tolerance

% Low-rank form of the right hand side.
[B11,B12]=trunc(tau*r1,speye(nt),trunctol);
B21 = sparse(nb,nt);
B22 = sparse(nt,nt);
B31 = sparse(n,nt); % Should be nonzero for nonhomegeneous boundaries
B32 = sparse(nt,nt); % Should be nonzero for nonhomegeneous boundaries

% Solver for the Schur-complement
solver = 'backslash'
% solver = 'amg' 
% In order for this to work you need to install a multigrid package. We
% have used HSL MI20 before but not guarantees here!

%% ALSO note that this is currently a proof-of-concept imeplementation as we use the matrix
% tau*inv(M)*K which is not too bad as M is diagonal but this should be
% used differently when another Sylvester solver is employed.

if strcmp(solver,'amg')
    % Setting up an algebraic multigrid for the matrix L=M+tau*K via the HSL
    % routine MI20, this is a global variable
    hsl_mi20_startup;
    control = hsl_mi20_control;
    control.v_iterations = 4;
%     inform = hsl_mi20_setup((1+tau/sqrt(beta))*M+tau*K,control);
    inform = hsl_mi20_setup(tau*inv(M)*K,control);   
    hsl_mi20_startup2;
    control2 = hsl_mi20_control2;
    inform2 = hsl_mi20_setup2(tau*((M)\K)',control2);
end


tic
[U11,U12,U21,U22,U31,U32,rdev]=lrminres(n,nb,nt,B11,B12,B21,B22,B31,B32,speye(nt),M,speye(nt),Mb,K,N,speye(nt),C,beta,tau,solver,tol,trunctol);
size(U11)
size(U21)
size(U31)
toc

%%
L=M+tau*K;
e=ones(nt);
C2=spdiags(-e,-1,nt,nt);
I=speye(nt);
b=[tau*rhs1;zeros(nb*nt+n*nt,1)];
A=[kron(I,tau*M) sparse(nt*n,nt*n) -(kron(I,L)+kron(C2,M))';sparse(nt*n,nt*n) kron(I,tau*beta*Mb) kron(I,tau*N');-(kron(I,L)+kron(C2,M)) kron(I,tau*N) sparse(nt*n,nt*n)];
x = A\b;
hans=U11*U12';
norm(hans(:)-x(1:n*nt))/norm(x(1:n*nt))
return
T=U11*U12';
normest(T-M\r1)/normest(M\r1)

for i=1:nt
    surf(vecplotdealii(T(:,i),ind_5_100,5));
    pause
end




