function [U11,U12,U21,U22,U31,U32,rankdev]=minrescsiamg(n,nb,nt,B11,B12,B21,B22,B31,B32,D1,M1,D2,M2,K,NN,D3,C,beta,tau,solver,tol,trunctol)
% MINRES implementation based on book Elman, Silvester, Wathen
% 
%
% MSTOLL 2013


% setting all the initial values
gamma0 = 1;


V11 = [];
V12 = [];
V21 = [];
V22 = [];
V31 = [];
V32 = [];

W11 = [];
W12 = [];
W21 = [];
W22 = [];
W31 = [];
W32 = [];

WW11 = [];
WW12 = [];
WW21 = [];
WW22 = [];
WW31 = [];
WW32 = [];

U11 = [];
U12 = [];
U21 = [];
U22 = [];
U31 = [];
U32 = [];


% initial residual
VV11 = B11;
VV12 = B12;
VV21 = B21;
VV22 = B22;
VV31 = B31;
VV32 = B32;

[VV11,VV12]=trunc(VV11,VV12,trunctol);
if (norm(V21,'fro')>0)
    [VV21,VV22]=trunc(VV21,VV22,trunctol);
end
if (norm(V31,'fro')>0)
    [VV31,VV32]=trunc(VV31,VV32,trunctol);
end
nr0 = sqrt(traceprod(VV11,VV12,VV21,VV22,VV31,VV32,VV11,VV12,VV21,VV22,VV31,VV32));
% applying the preconditioner
steps = 10; % number of csi steps
[Z11,Z12,Z21,Z22,Z31,Z32] = Aprec(D1,M1,D2,M2,K,NN,D3,C,n,nb,nt,beta,tau,VV11,VV12,VV21,VV22,VV31,VV32,solver,trunctol);
% [Z11,Z12]=trunc(Z11,Z12,trunctol);
% [Z21,Z22]=trunc(Z21,Z22,trunctol);
% [Z31,Z32]=trunc(Z31,Z32,trunctol);
gamma1 = sqrt(traceprod(Z11,Z12,Z21,Z22,Z31,Z32,VV11,VV12,VV21,VV22,VV31,VV32));
eta0 = gamma1; s0 = 0; s1 = 0; c0 = 1; c1 = 1;
eta =eta0;
iter = 0;
relres = 1;
iter =0;
itmax=60;
while iter<itmax      %%
    Z11 =Z11/gamma1;
    Z21 =Z21/gamma1;
    Z31 =Z31/gamma1;
    
    [AUX11,AUX12,AUX21,AUX22,AUX31,AUX32] = Amult(D1,M1,D2,M2,K,NN,D3,C,beta,tau,Z11,Z12,Z21,Z22,Z31,Z32,n,nt);
    %     if mod(iter,3) == 0
    [AUX11,AUX12]=trunc(AUX11,AUX12,trunctol);
    [AUX21,AUX22]=trunc(AUX21,AUX22,trunctol);
    [AUX31,AUX32]=trunc(AUX31,AUX32,trunctol);
    %     end
    delta = traceprod(AUX11,AUX12,AUX21,AUX22,AUX31,AUX32,Z11,Z12,Z21,Z22,Z31,Z32);
    
    VVV11 = [AUX11 (-delta/gamma1)*VV11 -(gamma1/gamma0)*V11];
    VVV21 = [AUX21 (-delta/gamma1)*VV21 -(gamma1/gamma0)*V21];
    VVV31 = [AUX31 (-delta/gamma1)*VV31 -(gamma1/gamma0)*V31];
    
    VVV12 = [AUX12 VV12 V12];
    VVV22 = [AUX22 VV22 V22];
    VVV32 = [AUX32 VV32 V32];
    
    [VVV11,VVV12]=trunc(VVV11,VVV12,trunctol);
    [VVV21,VVV22]=trunc(VVV21,VVV22,trunctol);
    [VVV31,VVV32]=trunc(VVV31,VVV32,trunctol);
    
    % applying the preconditioner
    [ZZ11,ZZ12,ZZ21,ZZ22,ZZ31,ZZ32] = Aprec(D1,M1,D2,M2,K,NN,D3,C,n,nb,nt,beta,tau,VVV11,VVV12,VVV21,VVV22,VVV31,VVV32,solver,trunctol);
    %     [ZZ11,ZZ12]=trunc(ZZ11,ZZ12,trunctol);
    %     [ZZ21,ZZ22]=trunc(ZZ21,ZZ22,trunctol);
    %     [ZZ31,ZZ32]=trunc(ZZ31,ZZ32,trunctol);
    
    
    gamma2 = sqrt(traceprod(ZZ11,ZZ12,ZZ21,ZZ22,ZZ31,ZZ32,VVV11,VVV12,VVV21,VVV22,VVV31,VVV32));
    
    alpha0 = c1*delta-c0*s1*gamma1;
    alpha1 = sqrt(alpha0^2+gamma2^2);
    invalpha = 1/alpha1;
    alpha2 = s1*delta + c0*c1*gamma1;
    alpha3 = s0*gamma1;
    c0 = c1; s0 = s1; c1 = alpha0*invalpha; s1 = gamma2*invalpha;
    
    WWW11 = [Z11 -alpha3*W11 -alpha2*WW11]*invalpha;
    WWW21 = [Z21 -alpha3*W21 -alpha2*WW21]*invalpha;
    WWW31 = [Z31 -alpha3*W31 -alpha2*WW31]*invalpha;
    WWW12 = [Z12  W12  WW12];
    WWW22 = [Z22  W22  WW22];
    WWW32 = [Z32  W32  WW32];
    %     if mod(iter,3) == 1
    [WWW11,WWW12]=trunc(WWW11,WWW12,trunctol);
    [WWW21,WWW22]=trunc(WWW21,WWW22,trunctol);
    [WWW31,WWW32]=trunc(WWW31,WWW32,trunctol);
    %     end
    
    U11 = [U11 c1*eta*WWW11];
    U12 = [U12 WWW12];
    U21 = [U21 c1*eta*WWW21];
    U22 = [U22 WWW22];
    U31 = [U31 c1*eta*WWW31];
    U32 = [U32 WWW32];
    %     if mod(iter,3) == 2    
% %     [U11,U12,vals]=truncvals(U11,U12,trunctol);
% %     t=iter*ones(size(vals,1),1)+vals*1i;
% %     plot(real(t),imag(t),'ro','MarkerSize',10,'LineWidth',3)
% %     hold on

    [U11,U12]=trunc(U11,U12,trunctol);    
    [U21,U22]=trunc(U21,U22,trunctol);
    [U31,U32]=trunc(U31,U32,trunctol);
    %     end
    eta = -s1*eta;
    
    gamma0 = gamma1; gamma1 = gamma2;
    
    V11 = VV11;
    V12 = VV12;
    V21 = VV21;
    V22 = VV22;
    V31 = VV31;
    V32 = VV32;
    
    VV11 = VVV11;
    VV12 = VVV12;
    VV21 = VVV21;
    VV22 = VVV22;
    VV31 = VVV31;
    VV32 = VVV32;
    
    Z11 = ZZ11;
    Z12 = ZZ12;
    Z21 = ZZ21;
    Z22 = ZZ22;
    Z31 = ZZ31;
    Z32 = ZZ32;
    
    W11 = WW11;
    W12 = WW12;
    W21 = WW21;
    W22 = WW22;
    W31 = WW31;
    W32 = WW32;
    
    
    WW11 = WWW11;
    WW12 = WWW12;
    WW21 = WWW21;
    WW22 = WWW22;
    WW31 = WWW31;
    WW32 = WWW32;
    
    iter = iter +1;
    resvec(iter) = abs(eta);
    relres = resvec(iter)/nr0
    rankdev(iter)=size(U11,2);
    if abs(relres)<tol
        iter
        relres
        break;
    end
end
iter
flag = 0;
