function [X1,X2]=ikpik_DCHE(A,LA,UA,B,LLB,UB,rhs1,rhs2,m,tol)
%function [X1,X2]=accel_sylv_mrhs_explicit(A,LA,UA,B,LLB,UB,rhs1,rhs2,m,tol)
%
% KPIK algorithm for Sylvester equation  (extended Krylov subspace type method)
%
%   solve    A X + X B' = rhs1 rhs2'    (mind the transposition in B !!)
%                                       rhs1,rhs2 tall matrices
%  assume sep(A,B) >0
%  A = LA*UA;   LU factorization of A
%  B = LLB*UB;   LU factorization of B
%  (modify the corresponding lines in the code if solves with A and B are performed inexactly)
%  m = max space dimension, say min(sqrt(size(A)),sqrt(size(B)))
%  tol = max final accuracy (in terms of relative residual)
%
%  [X1,X2] = solution factors   X_approx = X1 X2'
%
% NOT FOR DISTRIBUTION. TEST VERSION
%

%nrmb1=norm(rhs1,'fro');
%nrmb2=norm(rhs2,'fro');
%nrma=norm(A,'fro');
%nrmb=norm(B,'fro');

[n,sh]=size(rhs1);
[nB,sh1]=size(rhs2); if sh~=sh1, fprintf('wrong rhs size\n');return;end

odds=[];
oddsB=[];
kA_max = m;
kB_max = m;

% if norm(A-A',1)<1e-14, kA_max =2 ; else kA_max = m; end
% if norm(B-B',1)<1e-14, kB_max =2 ; else kB_max = m; end

s=2*sh;
for i=1:size(rhs1,2)
%     rhsA(:,i)=hsl_mi20_precondition2(rhs1(:,i)); % K is the stiffness matrix
      rhsA(:,i)=A\rhs1(:,i); % K is the stiffness matrix
end
rhsB=B\rhs2; % B is a triangular matrix

UU=[rhs1, rhsA];
WW=[rhs2, rhsB];

% Sequence in A
[ibeta,U(:,1:s)]=mgs(UU);
H=sparse((m+1)*s,m*s); L=sparse((m+1)*s,m*s);
beta=inv(ibeta); beta = beta(1:sh,1:sh);
% Sequence in B'
[ibetaB,W(:,1:s)]=mgs(WW);
HB=sparse((m+1)*s,m*s); LB=sparse((m+1)*s,m*s);
betaB=inv(ibetaB); betaB = betaB(1:sh,1:sh);

beta2=beta*betaB';

% fprintf('      it        abs res F-norm\n')

for j=1:m,
    
    jms=(j-1)*s+1;j1s=(j+1)*s;js=j*s;js1=js+1; jsh=(j-1)*s+sh;
    
    % Sequence in A
    Up(:,1:sh) = A*U(:,jms:jsh);
    for i=1:s-sh
%         Up(:,sh+i)=hsl_mi20_precondition2(U(:,jsh+i));
        Up(:,sh+i)=A\(U(:,jsh+i));
    end
    UU=[UU,Up];
    %new bases block (modified gram)
    for l=1:2
        k_min=max(1,j-kA_max);
        for kk=k_min:j
            k1=(kk-1)*s+1; k2=kk*s;
            coef= U(1:n,k1:k2)'*Up;
            H(k1:k2,jms:js) = H(k1:k2,jms:js)+ coef; % U(1:n,k1:k2)'*Up;
            Up = Up - U(:,k1:k2)*coef; %H(k1:k2,jms:js);
        end
    end
    if (j<=m)
        [hinv,U(1:n,js1:j1s)]=mgs(Up);
        H(js1:j1s,jms:js)=inv(hinv);
    end
    I=speye(js+s);
    %   if (j==1),
    %     L(1:j*s+sh,(j-1)*sh+1:j*sh) =...
    %     [ H(1:s+sh,1:sh)/ibeta(1:sh,1:sh), speye(s+sh,sh)/ibeta(1:sh,1:sh)]*ibeta(1:s,sh+1:s);
    %   else
    %     L(1:j*s+s,(j-1)*sh+1:j*sh) = L(1:j*s+s,(j-1)*sh+1:j*sh) + H(1:j*s+s,jms:jms-1+sh)*rho;
    %   end
    odds = [odds, jms:(jms-1+sh)];   % store the odd block columns
    evens = 1:js; evens(odds)=[];
    T(1:js+s,odds)=H(1:js+s,odds);   %odd columns
    T(1:js+sh,jms+sh:js)=U(:,1:js+sh)'*(A*U(:,jms+sh:js));
    
    %   T(1:js+sh,evens)=L(1:js+sh,1:j*sh);   %even columns
    %   L(1:j*s+s,j*sh+1:(j+1)*sh) = ...
    %      ( I(1:j*s+s,(js-sh+1):js)- T(1:js+s,1:js)*H(1:js,js-sh+1:js))*hinv(sh+1:s,sh+1:s);
    %   rho = hinv(1:sh,1:sh)\hinv(1:sh,sh+1:s);
    
    %Sequence in B'
    Wp(:,1:sh) = B*W(:,jms:jsh);
    %     Wp(:,sh+1:s) = UB\(LLB\W(:,jsh+1:js));
    Wp(:,sh+1:s) = (B\W(:,jsh+1:js));
    WW=[WW,Wp];
    %new bases block (modified gram)
    for l=1:2
        k_min=max(1,j-kB_max);
        for kk=k_min:j
            k1=(kk-1)*s+1; k2=kk*s;
            coef= W(1:nB,k1:k2)'*Wp;
            HB(k1:k2,jms:js) = HB(k1:k2,jms:js)+ coef;
            Wp = Wp - W(:,k1:k2)*coef;
        end
    end
    if (j<=m)
        [hinvB,W(1:nB,js1:j1s)]=mgs(Wp);
        H(js1:j1s,jms:js)=hinv\speye(size(hinv,1));
        %        HB(js1:j1s,jms:js)=inv(hinvB);
    end
    I=speye(js+s);
    % if (j==1),
    %   LB(1:j*s+sh,(j-1)*sh+1:j*sh) =...
    %   [ HB(1:s+sh,1:sh)/ibetaB(1:sh,1:sh), speye(s+sh,sh)/ibetaB(1:sh,1:sh)]*ibetaB(1:s,sh+1:s);
    % else
    %   LB(1:j*s+s,(j-1)*sh+1:j*sh) = LB(1:j*s+s,(j-1)*sh+1:j*sh) + HB(1:j*s+s,jms:jms-1+sh)*rhoB;
    % end
    oddsB = [oddsB, jms:(jms-1+sh)];   % store the odd block columns
    evens = 1:js; evens(oddsB)=[];
    TB(1:js+s,oddsB)=HB(1:js+s,oddsB);   %odd columns
    
    TB(1:js+sh,jms+sh:js)=W(:,1:js+sh)'*(B*W(:,jms+sh:js));
    %TB(1:js+sh,evens)=LB(1:js+sh,1:j*sh);   %even columns
    %LB(1:j*s+s,j*sh+1:(j+1)*sh) = ...
    %   ( I(1:j*s+s,(js-sh+1):js)- TB(1:js+s,1:js)*HB(1:js,js-sh+1:js))*hinvB(sh+1:s,sh+1:s);
    %rhoB = hinvB(1:sh,1:sh)\hinvB(1:sh,sh+1:s);
    
    I = speye(j*s);
    k=j;
    
    % Solve reduced dim sylvester eqn
    Y = lyap(full(T(1:js,1:js)),full(TB(1:js,1:js))',speye(k*s,sh)*beta2*speye(k*s,sh)');
    
    cc = [H(js1:j1s,js-s+1:js-sh), T(js1:j1s,js-sh+1:js)];
    %cc = [H(js1:j1s,js-s+1:js-sh), L(js1:j1s,(j-1)*sh+1:j*sh)];
    ccB = [HB(js1:j1s,js-s+1:js-sh), TB(js1:j1s,js-sh+1:js)];
    %ccB = [HB(js1:j1s,js-s+1:js-sh), LB(js1:j1s,(j-1)*sh+1:j*sh)];
    %   nrmx=norm(Y,'fro');
    res(k)=sqrt(norm(cc*Y(js-s+1:js,:),'fro')^2+norm(Y(:,js-s+1:js)*ccB','fro')^2);
    % True abs residual norm
    %   X=U(1:n,1:js)*Y*W(1:nB,1:js)';
    %   norm(A*X+X*B'+rhs1*rhs2','fro')
    
%     disp([k,res(k)])
    
    if (res(k)<tol), break, end
end

X1=U(1:n,1:js)*Y; X2=W(1:nB,1:js);

% fprintf('   its           comp.res.   space dim.  \n')
% disp([k,res(j),js])

return



function [u,q]=mgs(a)
%==================================================
% =============== a = q*inv(u) ====================
%==================================================
[q,u]=qr(a,0);
u=u\speye(size(u,1));
% u=inv(u);
return