% MINIMALEXAMPLE Test script for eigenvalue computation with NFFT-Lanczos.
%
% This code creates a simple dataset and uses the NFFT-based Lanczos method
% to compute the Fiedler vector, i.e. the eigenvector to the second
% smallest eigenvalue of the graph Laplacian. The vertices are then
% labelled according to the signs of the entries of the Fiedler vectors.
%
% This software is distributed under the GNU General Public License v2. See 
% COPYING for the full license text. If that file is not available, see 
% <http://www.gnu.org/licenses/>.
%
% Authors:
%   Dominik Alfke, TU Chemnitz, dominik.alfke(at)mathematik.tu-chemnitz.de
%   Toni Volkmer, TU Chemnitz, toni.volkmer(at)mathematik.tu-chemnitz.de


%% Create simple "Two Moons" dataset

n = 100000; % Total number of data points
r1 = 1.7; % Inner radius
r2 = 3;   % Outer radius

phi = pi*rand(n/2, 1);
X = (r1 + (r2-r1)*rand(n/2,1)) .* [cos(phi), sin(phi)];
X = [X; (r1+r2)/2 + X(:,1), -X(:,2)];


%% Set options

opts.sigma = 1; % Scaling parameter, might need to be adapted if r1 and r2 are changed
opts.N = 64;
opts.m = 2;
opts.p = 2;
opts.eps_B = 2/64;
opts.eigs_tol = 1e-4;

%% Compute eigenpairs
% (Smallest eigenvalues of graph Laplacian) = 1 - (largest eigenvalues of 
% normalized adjacency matrix)

tic;
[V, D, S] = fastsumAdjacencyEigs(X, 2, opts);
fprintf('Time for fastsum setup and eigenvalue computation: %gs\n', toc);
fprintf('Laplacian Eigenvalue corresponding to Fiedler vector: %.4e\n', 1 - D(2,2));

%% Clustering

fiedler = V(:,2);

labels = zeros(n, 1);
labels(fiedler < 0) = 1;
labels(fiedler > 0) = 2;

%% Plot results

figure;
colormap([1,0,0; 0,0.8,0]);
scatter(X(:,1), X(:,2), 15, labels);
axis equal;