% Definieren der exakten Funktion u und f = Laplace u
u = @(X) exp(X(:,1) .* X(:,2));
f = @(X) (X(:,1).^2 + X(:,2).^2) .* u(X);

% Nur C^3-Funktion testen:
%u = @(X) X(:,1).^(3.1);
%f = @(X) 3.1 * 2.1 * (X(:,1).^1.1);

% Vektor von Schrittweiten h
h = 2.^(-(4:11));

% Fehlerberechnung von L_h u_h - f fuer die verschiedenen h
error = zeros(length(h),3);
for i = 1:length(h),
   x = 0 : h(i) : 1;
   [X,Y] = meshgrid(x,x);
   X = X(:); Y = Y(:);
   Luh = Apply_DiscreteLaplace_FivePointStar( u( [X,Y] ) );
   fh = f([X,Y]);
   
   err = Restrict_to_Inner(fh) - Luh;
   
   error(i, 1) = Linfty_Norm_Unitsquare(err);
   error(i, 2) = L2_Norm_Unitsquare(err);
end

% Bestimmung der experimentellen Konsistenzordnung
p_Linfty = eoc(h, error(:,1));
p_L2 = eoc(h, error(:,2));

% Zeichnen der Fehlerkurven
loglog(h, error(:,1:2),'-o','LineWidth',2)
xlabel('h','FontSize',25); 
ylabel('error','FontSize',25);
title('Experimental consistency order of five point star','FontSize',30);
legend(sprintf('L^\\infty error (p = %.2f)', p_Linfty),...
    sprintf('L^2 error (p = %.2f)', p_L2))
set(gca, 'FontSize', 25)