function L = Apply_DiscreteLaplace_FivePointStar(u)
% Apply_DiscreteLaplace_FivePointStar computes the discrete Laplace 
% operator with the 5-Point Star scheme applied to discrete function u 
% (stored as vector)

% Set the discretization parameter n
n = sqrt(size(u,1))-1;
% Compute the corresponding h
h = 1/n;

% Reshape input vector u
U = reshape(u,n+1,n+1);

% Compute the discrete Laplace operator (in the inner points)
L = -1/h^2 * ( 4*U(2:n,2:n) - U(1:n-1,2:n) - U(3:n+1,2:n) - U(2:n,1:n-1) - U(2:n,3:n+1) );
% Cast L to a vector
L = L(:);
