t0 = 0;
y0 = 0.1;
T = 10;

f = @(t,y) y.*(1-y);

h = 0.3;
t = t0:h:T;
y_true = 1 ./ (1 + (1/y0-1) * exp(-t));
y_euler = euler_explicit(h,f,t0,y0,T);
y_mod = euler_modified(h,f,t0,y0,T);

figure()
subplot(1,2,1)
plot(t0:h:T,y_true,'-k',t0:h:T,y_euler,'-b', t0:h:T,y_mod,'-r' )

err = zeros(2,10);
for i = 1:10,
    h = 2^(-i);
    t = t0:h:T;
    y_true = 1 ./ (1 + (1/y0-1) * exp(-t));
    y_euler = euler_explicit(h,f,t0,y0,T);
    y_mod = euler_modified(h,f,t0,y0,T);
    
    err(1,i) = norm( y_euler - y_true, Inf);
    err(2,i) = norm( y_mod - y_true, Inf);
end
subplot(1,2,2);
loglog(2.^((1:10)), err(1,:), '-b', 2.^((1:10)), err(2,:), '-r')

    
