%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
% Briefklasse für das Corporate Design 2014 der TU Chemnitz                   %
% (c) Mario Haustein (mario.haustein@hrz.tu-chemnitz.de), 2013-2014           %
%                                                                             %
% Dieses Material steht unter der Creative-Commons-Lizenz Namensnennung -     %
% Keine Bearbeitungen 4.0 International. Um eine Kopie dieser Lizenz zu       %
% sehen, besuchen Sie http://creativecommons.org/licenses/by-nd/4.0/deed.de.  %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\ProvidesClass{tucletter2014}[2014/05/22]

% Druck in S/W
\newif\iftucblack\tucblackfalse
\DeclareOption{black}{\tucblacktrue}

% Englische Briefe
\newif\iftucenglish\tucenglishfalse
\DeclareOption{eng}{\tucenglishtrue}

% Kopfzeile abschalten (für vorgedrucktes Briefpapier).
\newif\iftuc@head\tuc@headtrue
\DeclareOption{nohead}{\tuc@headfalse}

% Standard-Schriften verwenden.
\newif\iftuc@roboto\tuc@robototrue
\DeclareOption{latexfonts}{\tuc@robotofalse}

% Umschaltung zwischen persönlichen Angaben und Strukturangaben
\newif\iftuc@myname\tuc@mynametrue
\newif\iftuc@myloc\tuc@mylocfalse
\newif\iftuc@myphone\tuc@myphonefalse
\newif\iftuc@myfax\tuc@myfaxfalse
\newif\iftuc@myemail\tuc@myemailfalse
\DeclareOption{usemyname}{\tuc@mynametrue}
\DeclareOption{usemyloc}{\tuc@myloctrue}
\DeclareOption{usemyphone}{\tuc@myphonetrue}
\DeclareOption{usemyfax}{\tuc@myfaxtrue}
\DeclareOption{usemyemail}{\tuc@myemailtrue}
\DeclareOption{usemycontact}{\tuc@myloctrue\tuc@myphonetrue\tuc@myfaxtrue\tuc@myemailtrue}
\DeclareOption{usedepname}{\tuc@mynamefalse}
\DeclareOption{usedeploc}{\tuc@mylocfalse}
\DeclareOption{usedepphone}{\tuc@myphonefalse}
\DeclareOption{usedepfax}{\tuc@myfaxfalse}
\DeclareOption{usedepemail}{\tuc@myemailfalse}
\DeclareOption{usedepcontact}{\tuc@mylocfalse\tuc@myphonefalse\tuc@myfaxfalse\tuc@myemailfalse}

% Keine Gesamtseitenanzahl angeben.
\newif\iftuc@totpages\tuc@totpagestrue
\DeclareOption{nototpages}{\tuc@totpagesfalse}

% Folgelogos ausschalten.
\newif\iftuc@contlogo\tuc@contlogotrue
\DeclareOption{nocontlogo}{\tuc@contlogofalse}

% Umsatzsteuer-ID anzeigen.
\newif\iftuc@taxid\tuc@taxidfalse
\DeclareOption{showtaxid}{\tuc@taxidtrue}


% Default-Werte aus tucletter.lco laden.
\PassOptionsToClass{tucletter2014}{scrlttr2}

% Per default einseitiges Layout
\PassOptionsToClass{oneside}{scrlttr2}

% Die restlichen Optionen an die Basisklasse weiterreichen.
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{scrlttr2}}

% Optionen verarbeiten.
\ProcessOptions\relax

% Ein einseitiges Layout erzwingen, wenn das Logo auf jedem Seitenkopf zu sehen
% sein soll, 
\iftuc@contlogo
\PassOptionsToClass{oneside}{scrlttr2}
\fi

% Version der Klasse festlegen (wichtig für Koexistenz zu lco-Dateien der alten Klasse).
\gdef\tucletter@version{2014}

% Auf der KOMA-Script Briefklasse aufbauen.
\LoadClass[fontsize=11pt]{scrlttr2}
\AtBeginDocument{\KOMAoptions{paper=a4}}	% A4-Fehlermeldung unterdrücken


% footskip:  30pt
% headsep:   26.1mm = 48.0mm (Papierrand bis Oberkante Satzspiegel laut CI) -
%                     10.6mm (Rand bis zur Kopfzeile) -
%                     13.5pt (Höhe Kopfzeile)
%                   = 92.9pt
%                   = Höhe des Briefkopfes (wenn Logo auf Folgeseiten angezeigt wird)
% headsep:   13.5pt = Eine Zeile (wenn kein Logo auf Folgeseiten angezeigt wird)
% hedheight: 13.5pt = Eine Zeile
\iftuc@contlogo
\RequirePackage[a4paper,includeheadfoot,inner=25mm,outer=18mm,top=10.6mm,bottom=10.6mm,footskip=30pt,headheight=13.5pt,headsep=92.9pt,nomarginpar]{geometry}
\else
\RequirePackage[a4paper,includeheadfoot,inner=25mm,outer=18mm,top=10.6mm,bottom=10.6mm,footskip=30pt,headheight=13.5pt,headsep=14.2pt,nomarginpar]{geometry}
\fi
\RequirePackage{graphicx}
\RequirePackage{xcolor}
\RequirePackage{calc}
\RequirePackage{xifthen}
\RequirePackage{ifxetex}
\RequirePackage{ifluatex}
\iftuc@totpages\RequirePackage{lastpage}\fi


\ifxetex
\RequirePackage{fontspec}
\RequirePackage{xunicode}
\else
\ifluatex
\RequirePackage{fontspec}
\RequirePackage{xunicode}
\else
\RequirePackage[T1]{fontenc}
\fi\fi


%
% Schrift
%

% Zunächst ein Paar KOMA-Fonts definieren.
\newkomafont{headline}{\relax}
\newkomafont{footline}{\relax}
\newkomafont{locfield}{\relax}
\newkomafont{enclseparator}{\relax}
\newkomafont{ccseparator}{\relax}

% Wenn gewünscht Roboto laden.
\iftuc@roboto
\RequirePackage{tucroboto}[2014/06/18]
\renewcommand{\rmdefault}{robc}
\renewcommand{\sfdefault}{robc}
\renewcommand{\seriesdefault}{l}
\setkomafont{headline}{\robcfamily\mdseries}
\setkomafont{footline}{\robcfamily\liseries}
\setkomafont{locfield}{\robcfamily\liseries}
\setkomafont{addressee}{\robcfamily\liseries}
\setkomafont{specialmail}{\robcfamily\liseries}
\setkomafont{backaddress}{\robcfamily\liseries}
\setkomafont{pagenumber}{\robcfamily\liseries}
%\setkomafont{placeanddate}{\robcfamily\liseries}	% erst ab scrlttr2 v3.12
\setkomafont{subject}{\robcfamily\mdseries}
\setkomafont{enclseparator}{\robcfamily\mdseries}
\setkomafont{ccseparator}{\robcfamily\mdseries}
\fi

% Wirkt sich nur aus, wenn der Nutzer manuell andere Schriften lädt.
\renewcommand{\familydefault}{\sfdefault}

\renewcommand*{\headfont}{}
\renewcommand*{\footfont}{}
\renewcommand*{\pnumfont}{\usekomafont{pagenumber}}


%
% Farbe
%
\iftucblack
\definecolor{tuccolor}{RGB}{0,0,0}
%\definecolor{tuccolor}{cmyk}{0.0,0.0,0.0,1.0}
\def\tuc@logo{tuc2014/logo/tuc_black}
\else
\definecolor{tuccolor}{RGB}{0,62,47}
%\definecolor{tuccolor}{cmyk}{1.0,0.16,0.69,0.70}
\def\tuc@logo{tuc2014/logo/tuc_green}
\fi


%
% Laut CI kein Einzug beim Beginn eines neuen Absatzes. Absatzabstand
% entspricht einem Zeilenabstand. Weiterhin wird sichergestellt, dass am Ende
% jeder Zeile mindestens 1em Freiraum bleibt.
%
\setlength{\parindent}{0pt}
\setlength{\parskip}{\baselineskip}
\setlength{\parfillskip}{1em plus 1fil}


%
% Abmessungen des Adressfensters nach DIN
%
% Einzug oberer Rand:   50mm
% Einzug linker Rand:   20mm
% Einzug rechter Rand: 105mm
% Höhe:                 40mm
%
% Die Haus-CI vergrößert die Höhe auf 45mm und
% verkleinert den oberen Rand auf 48mm.
%

% Kopfzeile
\@setplength{firstheadvpos}{10.6mm}
\@setplength{firstheadhpos}{25mm}
\@setplength{firstheadwidth}{167mm}	% 210mm - 25mm - 18mm

% Adressfenster
\@setplength{toaddrhpos}{25mm}
\@setplength{toaddrvpos}{48mm}
\@setplength{toaddrwidth}{85mm}
\@setplength{toaddrheight}{45mm}
\@setplength{backaddrheight}{10pt}	% 1 Zeile: SG 8pt + 2pt zusätzlich Luft
\@setplength{toaddrindent}{0pt}

% Fußzeile
\@setplength{firstfootvpos}{265mm}	% 297mm - 10.6mm - (8pt + 5 * 9.4pt + 5.65pt + \epsilon = 21.4mm)
\@setplength{firstfoothpos}{25mm}
\@setplength{firstfootwidth}{167mm}	% 210mm - 25mm - 18mm

% Betreff und nicht vorhandene Geschäftszeile
\@setplength{refvpos}{106mm}		% 48mm + 45mm + 13mm
\@setplength{refhpos}{25mm}
\@setplength{refwidth}{167mm}		% 210mm - 25mm - 18mm
\@setplength{refaftervskip}{0pt}
\@setplength{subjectbeforevskip}{0pt}
\@setplength{subjectaftervskip}{13.5pt}

% Absenderergänzung
\@setplength{lochpos}{18mm}
\@setplength{locvpos}{48mm}
\@setplength{locwidth}{65mm}
\@setplength{locheight}{45mm}

% Unterschrift
\@setplength{sigindent}{0pt}
\@setplength{sigbeforevskip}{3\baselineskip}


%
% Die Geschäftszeile ausblenden.
%
\KOMAoptions{refline=nodate}
\removereffields


%
% Adressfenster
%

% Keine Linie bei Absenderangabe
\KOMAoptions{backaddress=plain}

% Absenderinformation wächst nach unten. Achtung, die Box ist 10pt hoch, aber
% nur 8pt (\f@size) davon sind nutzbar. Bei mehreren Zeilen läuft die Box also
% ins Empfängerfeld hinein. Die zusätzlichen 2pt schaffen im Endeffekt ca. 12pt
% Zeilenabstand zur ersten Empfängerzeile, wenn alle 9 Zeilen benutzt werden.
% Obwohl laut CI nur 10pt festgelegt sind (d.h. der Zusatzabstand entfallen
% könnte), erschien der Abstand bei der Sichtprüfung zu gering.
\setkomavar{backaddressseparator}{\usekomavar{tucseparator}}
\setkomavar{backaddress}{\raisebox{2pt}{\rule{0pt}{\f@size pt}\smash{\parbox[t]{\hsize}{%
\raggedright\def\\{\usekomavar{backaddressseparator}\@ogobble}\usekomavar{tucbackaddress}}}}}

% Schriftgröße Absenderinformation
\addtokomafont{backaddress}{\fontsize{8pt}{10pt}\selectfont}

% Schriftgröße Empfänger
\addtokomafont{addressee}{\fontsize{11pt}{13.5pt}\selectfont}


%
% Versandart (sollte aber nicht genutzt werden)
%

% Formatierung
\renewcommand*{\specialmail@format}[1]{#1}

% Schriftgröße
\addtokomafont{specialmail}{\fontsize{11pt}{13.5pt}\selectfont}


%
% Anlagen und Verteiler
%
% Das ist ein Dirty-Hack, der KOMA-Interna ausnutzt.
%
\AtBeginLetter{%
\let\@rgscr@enclseparator@name\scr@enclseparator@name%
\let\@rgscr@enclseparator@var\scr@enclseparator@var%
\let\@rgscr@ccseparator@name\scr@ccseparator@name%
\let\@rgscr@ccseparator@var\scr@ccseparator@var%
\def\scr@enclseparator@name{\usekomafont{enclseparator}\@rgscr@enclseparator@name}%
\def\scr@enclseparator@var{\usekomafont{enclseparator}\@rgscr@enclseparator@var}%
\def\scr@ccseparator@name{\usekomafont{ccseparator}\@rgscr@ccseparator@name}%
\def\scr@ccseparator@var{\usekomafont{ccseparator}\@rgscr@ccseparator@var}}


%
% Faltmarken bei vorgedrucktem Papier deaktivieren.
%
\iftuc@head\else
\KOMAoptions{foldmarks=off}
\fi

% Da scrlttr2 nur Linien als Faltmarken vorsieht, verkaufen wir ein Rechteck als Punkt.
%\@setplength{foldmarkhpos}{3mm}
%\@setplength{foldmarkthickness}{0.8pt}
%\@setplength{bfoldmarklength}{0.8pt}
%\@setplength{lfoldmarklength}{0.8pt}
%\@setplength{mfoldmarklength}{0.8pt}
%\@setplength{pfoldmarklength}{0.8pt}
%\@setplength{tfoldmarklength}{0.8pt}


%
% Betreff
%
\KOMAoptions{subject=untitled}
\addtokomafont{subject}{\fontsize{11pt}{13.5pt}\selectfont}


%
% Numerische Datumsangaben
%
\KOMAoptions{numericaldate}


%
% Signum linksbündig setzen und Funktion ergänzen.
%
\let\raggedsignature\raggedright

% Signum ohne Bild
\newcommand{\makesignature}[2][]{\ifthenelse{\isempty{#1}}{#2}{#2\newline\fontsize{11pt}{13.5pt}\selectfont #1}}

% Signum mit Bild
\newcommand{\makesignaturefig}[3][]{%
\hbox to 0pt{\smash{\raisebox{\baselineskip}{\includegraphics[height=0.85\useplength{sigbeforevskip}]{#3}}}\hss}%
\makesignature[#1]{#2}}

% Etwas umständlich, da ein \usekomavar im optionalen Argument als nichtleer gewertet wird.
\AtBeginLetter{\ifkomavarempty{signature}{\setkomavar{signature}{\ifkomavarempty{mysignature}{\relax}{\ifkomavarempty{myfunction}%
{\makesignature{\usekomavar{mysignature}}}{\makesignature[\usekomavar{myfunction}]{\usekomavar{mysignature}}}}}}{\relax}}


%
% Kontaktdaten
%
% Diese \ifkomvavarempty-Orgie ist ein dirty Hack, der sicherstellen soll
% dass die Variablen für die Kontaktdaten richtig expandiert werden. Enthält
% eine KOMA-Variable einen \usekoma-Befehl, der zu nichts expandiert wird, wird
% die übergeordnete KOMA-Variable trotzdem als nichtleer angesehen. Dies würde zu
% einem falschen Vorrang führen.
%
% Dieses Konstrukt aus KOMA-Variablen dient dazu, den Vorrang zwischen
% persönlichen Angaben und Angaben der Struktureinheit zu realisieren.
% Es ist ebenfalls möglich die Standardformatierung im Zweifel auszuhebeln,
% z.B. wenn Telefonnummern anzugeben sind, die nicht ins Nummernschema der
% Universität passen (abweichende Vorwahl, etc.).
%
\AtBeginLetter{%
\ifkomavarempty{showname}{\iftuc@myname%
\ifkomavarempty{myname}{\relax}{\setkomavar{showname}[\usekomavar*{myname}]{\usekomavar{myname}}}\else%
\ifkomavarempty{depname}{\relax}{\setkomavar{showname}[\usekomavar*{depname}]{\usekomavar{depname}}}\fi}{\relax}%
\ifkomavarempty{showloc}{\iftuc@myloc%
\ifkomavarempty{myloc}{\relax}{\setkomavar{showloc}[\usekomavar*{myloc}]{\usekomavar{myloc}}}\else%
\ifkomavarempty{deploc}{\relax}{\setkomavar{showloc}[\usekomavar*{deploc}]{\usekomavar{deploc}}}\fi}{\relax}%
\ifkomavarempty{showroom}{\iftuc@myloc%
\ifkomavarempty{myroom}{\relax}{\setkomavar{showroom}[\usekomavar*{myroom}]{\usekomavar{myroom}}}\else%
\ifkomavarempty{deproom}{\relax}{\setkomavar{showroom}[\usekomavar*{deproom}]{\usekomavar{deproom}}}\fi}{\relax}%
\ifkomavarempty{showphone}{\iftuc@myphone%
\ifkomavarempty{myphone}{\relax}{\setkomavar{showphone}[\usekomavar*{myphone}]{\usekomavar{tucphoneprefix}-\usekomavar{myphone}}}\else%
\ifkomavarempty{depphone}{\relax}{\setkomavar{showphone}[\usekomavar*{depphone}]{\usekomavar{tucphoneprefix}-\usekomavar{depphone}}}\fi}{\relax}%
\ifkomavarempty{showfax}{\iftuc@myfax%
\ifkomavarempty{myfax}{\relax}{\setkomavar{showfax}[\usekomavar*{myfax}]{\usekomavar{tucfaxprefix}-\usekomavar{myfax}}}\else%
\ifkomavarempty{depfax}{\relax}{\setkomavar{showfax}[\usekomavar*{depfax}]{\usekomavar{tucfaxprefix}-\usekomavar{depfax}}}\fi}{\relax}%
\ifkomavarempty{showemail}{\iftuc@myemail%
\ifkomavarempty{myemail}{\relax}{\setkomavar{showemail}[\usekomavar*{myemail}]{\usekomavar{myemail}}}\else%
\ifkomavarempty{depemail}{\relax}{\setkomavar{showemail}[\usekomavar*{depemail}]{\usekomavar{depemail}}}\fi}{\relax}%
\ifkomavarempty{showurl}{%
\ifkomavarempty{depurl}{\relax}{\setkomavar{showurl}[\usekomavar*{depurl}]{\usekomavar{depurl}}}}{\relax}}


%
% Kopf- und Fußzeilen für die Folgeseiten.
%
\pagestyle{myheadings}


%
% Briefkopf
%
\newcommand{\m@keheadline}[3]{\raisebox{#2}{\makebox{\hbox to #1{#3\hfill}}}}
\setkomavar{firsthead}{%
\newcommand{\largeheadline}{\fontsize{14}{19}\selectfont}%
\newcommand{\smallheadline}{\fontsize{12}{18}\selectfont}%
\usekomafont{headline}%
\setlength{\unitlength}{1mm}%
\begin{picture}(167, 26.1)(0, -26.1)
\iftuc@head
% -1.4mm = 12mm (Abstand Logo) - 10.6mm (oberer Rand)
\makebox(0, -1.4)[lt]{\includegraphics[width=46.5mm]{\tuc@logo}\hspace*{10mm}}\fi
\put(56.5, -26.1){\makebox(0, 26.1)[b]{\hspace*{-0.375pt}\vrule width 0.75pt height 26.1mm}}
% 100.5mm = 210mm - 25mm - 66.5mm - 18mm = max. Breite der Textzeilen
% 19.58mm = empirisch ermittelt
% Laut CI soll der Zeilenabstand 18pt betragen, wurde hier aber auf 20pt
% festgelegt, damit die Kopfzeilen bündig mit dem Logo sind.
\put(66.5, -19.58){\m@keheadline{100.5mm}{40pt}{\largeheadline\usekomavar{tucheadline1}}}
\put(66.5, -19.58){\m@keheadline{100.5mm}{20pt}{\smallheadline\usekomavar{tucheadline2}}}
\put(66.5, -19.58){\m@keheadline{100.5mm}{00pt}{\smallheadline\usekomavar{tucheadline3}}}
\end{picture}}


%
% Kopf der Folgeseiten
%
% - Das Logo ist 46.5mm breit.
% - Das Logo wird 13.5pt nach oben verschoben, da die Grundlinie der Kopfzeile
%   13.5pt unter dem 10.6mm-Rand des Satzspiegels liegt.
%
\setkomavar{nexthead}{}
\iftuc@contlogo\iftuc@head
\setkomavar{nexthead}{\hsize=46.5mm\vbox to 0pt{\vskip -13.5pt\includegraphics[width=46.5mm]{\tuc@logo}\vss}\hfill}
\fi\fi


%
% Fußzeile der ersten Briefseite
%
% Das \if@tempswa-Konstrukt dient dazu leere Fußzeilen auszulassen.
%
% Mittels \removelastskip wird evt. überflüssiger vertikaler Zwischenraum
% getilgt, sollte ein Block ganz entfallen.
%
% Am Ende ist ein vertikaler Zwischenraum von 0pt erforderlich, damit
% \removelastskip wirkt.
%
% Die Fußzeile wird auf folgende Weise konstruiert_
%
% 1. Die Kontaktangaben werden gesetzt und in einer Box gespeichert.
% 2. Die Höhe dieser Box wird gemessen.
% 3. Die Logo-Box mit vorgegebener Breite und gemessener Höhe wird konstruiert.
% 4. Die gespeicherte Fußzeilenbox wird ausgegeben.
%
%  21.4mm = Höhe Fußzeile
%  46.5mm = Breite TU-Logo       = Breite Logo-Box
% 100.5mm = Länge der Kopfzeilen = Länge der Fußzeilen
%
\newcommand{\m@kefootentry}[2]{%
\ifkomavarempty{#1}{\relax}{\usekomavar*{#1}\ifkomavarempty*{#1}{\relax}{#2}\usekomavar{#1}}}

\setkomavar{firstfoot}{%
\begin{minipage}[b][21.4mm][b]{\hsize}
\usekomafont{footline}\fontsize{8pt}{9.4pt}\selectfont%
\newsavebox{\footlines}
\savebox{\footlines}{%
\parbox[b]{100.5mm}{%
\raggedright%
\def\\{\usekomavar{tucseparator}\@ogobble}%
\ifkomavarempty{visitaddress}{}{\par\m@kefootentry{visitaddress}{:~}}%
\ifkomavarempty{fromaddress}{}{\par\m@kefootentry{fromaddress}{:~}}%
\removelastskip
\vskip 5.65pt%
\@tempswatrue%
\ifkomavarempty{tucbankaccount}{\@tempswafalse}{}%
\ifkomavarempty{tucbankcode}{\@tempswafalse}{}%
\ifkomavarempty{tucbankaccountnr}{\@tempswafalse}{}%
\if@tempswa%
\par\m@kefootentry{tucbankaccount}{:~}%
\par\m@kefootentry{tucbankaccountnr}{:~}\\\m@kefootentry{tucbankcode}{:~}%
\iftuc@taxid\ifkomavarempty{tuctaxid}{\relax}{\\\m@kefootentry{tuctaxid}{:~}}\fi%
\fi%
\removelastskip%
\vskip 0pt}}%
\setlength{\vsize}{\ht\footlines}
% Mindestgröße des Logos (4 Fu0zeilen + Zwischenraum):
%   8pt + 3 * 9.4pt + 5.65pt = 41.85pt
\ifdim\vsize<41.85pt\setlength{\vsize}{41.85pt}\fi
\begin{minipage}[b][\vsize][c]{46.5mm}
\ifkomavarempty{logo}{\m@kelogos}{\usekomavar{logo}}%
\end{minipage}%
\hfill%
\usebox{\footlines}%
\end{minipage}}


%
% Fußzeile der Folgeseiten
%
\iftucenglish
\newcommand{\ofname}{of}
\else
\newcommand{\ofname}{von}
\fi

\newcommand{\m@kepage}{\pagename~\thepage\iftuc@totpages~\ofname~\pageref{LastPage}\fi}
\setkomavar{nextfoot}{\if@twoside\ifthispageodd{\hfill\m@kepage}{\m@kepage\hfill}\else\hfill\m@kepage\fi}


%
% Absenderergänzung
%
\KOMAoptions{fromalign=off}

\newcommand{\m@kelocline}[2]{\par\hbox{\rule{0pt}{\f@size pt}%
\hbox to 20mm{#1:\hfill}\parbox[t]{45mm}{\raggedright #2}}}

\setkomavar{location}{%
\usekomafont{locfield}%
\fontsize{8pt}{11.35pt}\selectfont%
\hbox to 0pt{%			% Hack, da KOMA-Script nicht die volle location-Box ausnutzt (vlt. ein Bug?)
\begin{minipage}[t]{\hsize}
\@tempswafalse%
\ifkomavarempty{myref}{\relax}{\m@kelocline{\usekomavar*{myref}}{\usekomavar{myref}}\@tempswatrue}%
\if@tempswa\vskip\baselineskip\fi%
\@tempswafalse%
\ifkomavarempty{showname}{\relax}{\m@kelocline{\usekomavar*{showname}}{\usekomavar{showname}}\@tempswatrue}%
\ifkomavarempty{showloc}{\relax}{\m@kelocline{\usekomavar*{showloc}}{\usekomavar{showloc}}\@tempswatrue}%
\ifkomavarempty{showroom}{\relax}{\m@kelocline{\usekomavar*{showroom}}{\usekomavar{showroom}}\@tempswatrue}%
\ifkomavarempty{showphone}{\relax}{\m@kelocline{\usekomavar*{showphone}}{\usekomavar{showphone}}\@tempswatrue}%
\ifkomavarempty{showfax}{\relax}{\m@kelocline{\usekomavar*{showfax}}{\usekomavar{showfax}}\@tempswatrue}%
\ifkomavarempty{showemail}{\relax}{\m@kelocline{\usekomavar*{showemail}}{\usekomavar{showemail}}\@tempswatrue}%
\ifkomavarempty{showurl}{\relax}{\m@kelocline{\usekomavar*{showurl}}{\usekomavar{showurl}}\@tempswatrue}%
\if@tempswa\vskip\baselineskip\fi%
\@tempswafalse%
\ifkomavarempty{date}{\relax}{\m@kelocline{\ifkomavarempty{place}{\relax}{\usekomavar*{place},~}\usekomavar*{date}}{\ifkomavarempty{place}{\relax}{\usekomavar{place}\usekomavar{placeseparator}}\usekomavar{date}}\@tempswatrue}%
\end{minipage}\hss}}


%
% Logo-Container
%
% Die Logos sollen ein Maximum der zur Verfügung stehenden Fläche ausnutzen.
%
% Bei einem Logo wird das Logo durch \includegraphics so weit skaliert, dass
% sowohl Höhe als auch Breite eingehalten werden.
%
% Im Fall zweier Logos gibt es zwei Fälle zu betrachten.
%
% Fall 1: Beide Logos werden durch die Höhe des Containers begrenzt. Dann muss
%         zusätzlicher horizontaler Zwischenraum zwischen den Logos eingefügt
%         werden.
% Fall 2: Die Logos werden durch die Containerbreite begrenzt. Es soll laut CI
%         die genutzte Fläche maximiert werden. Dies führt u.U. aber dazu, dass
%         ein Logo sehr groß skaliert wird und das andere klein. Das "Optimum"
%         entspricht einem der folgenden Fälle:
%
%    x_1 = X - Y / r_2   x_2 =     Y / r_2   (Logo 2 hat volle Höhe)
%    x_1 =     Y / r_1   x_2 = X - Y / r_1   (Logo 1 hat volle Höhe)
%
%         Wobei die Variablen folgende Bedeutung haben:
%
%    r_1, r_2 ... Verhältnis von Höhe zu Breite der Logos
%    X, Y     ... Abmessungen des Logo-Containers
%    x_1, x_2 ... Breite von Logo 1 bzw. Logo 2
%
%
% Achtung: Wenn r_1 = r_2, dann führen beide Wahlmöglichkeiten für x_1 und x_2
%          zur selben Flächenausnutzung, aber zu vollkommen unterschiedlichen
%          Layouts. Für r_1 = r_2 = X / Y nimmt ein Logo den kompletten Platz
%          ein und das andere verschwindet.
%
% Aus diesem Grund ist es sinnvoller beide Logos so zu skalieren, dass sie die
% selbe Höhe einnehmen und den horizontalen Platz ausnutzen. Das ist allerdings
% genau der Fall, in dem die ausgenutze Fläche minimal wird. x_1 und x_2
% berechnen sich dann durch:
%
%    x_1 = r_1 / (r_1 + r_2) * X
%    x_2 = r_2 / (r_1 + r_2) * X
%
% Diese Variante sollte damit eher den Intentionen der CI-Autoren entsprechen
% und hat den Vorteil, dass bei richtiger Implementierung die obige
% Fallunterscheidung nicht mehr notwendig ist.
%

% Logo-Container füllen.
\newcommand{\m@kelogos}{\ifkomavarempty{logo1}{\relax}{\ifkomavarempty{logo2}{\m@kelogos@single}{\m@kelogos@double}}}

% Ein Logo
\newcommand{\m@kelogos@single}{\usekomavar[\edef\l@g@]{logo1}%
\includegraphics[height=\vsize,width=\hsize,keepaspectratio]{\l@g@}\hspace*{\fill}}

% Zwei Logos
\newcommand{\m@kelogos@double}{%
\newsavebox{\logoi}%
\newsavebox{\logoii}%
\savebox{\logoi}{\usekomavar[\edef\l@g@]{logo1}\includegraphics{\l@g@}}%
\savebox{\logoii}{\usekomavar[\edef\l@g@]{logo2}\includegraphics{\l@g@}}%
\newlength{\l@g@scale}\setlength{\l@g@scale}{\hsize*\ratio{1pt}{1pt*\ratio{\ht\logoi}{\wd\logoi} + 1pt*\ratio{\ht\logoii}{\wd\logoii}}}%
\newlength{\l@g@iwidth}\setlength{\l@g@iwidth}{\l@g@scale*\ratio{\ht\logoii}{\wd\logoii}}%
\newlength{\l@g@iiwidth}\setlength{\l@g@iiwidth}{\l@g@scale*\ratio{\ht\logoi}{\wd\logoi}}%
\usekomavar[\edef\l@g@]{logo1}\(\vcenter{\hbox{\includegraphics[width=0.9\l@g@iwidth,height=\vsize,keepaspectratio]{\l@g@}}}\)%
\hspace*{\fill}%
\usekomavar[\edef\l@g@]{logo2}\(\vcenter{\hbox{\includegraphics[width=0.9\l@g@iiwidth,height=\vsize,keepaspectratio]{\l@g@}}}\)}


\endinput
