function [d,p] = abstand(x,v)
% Projektion eines Punktes x auf die Ebene mit Normalenvektor v und 
%Berechnung des minimalen Abstandes

% bestimme die skalare Projektion des Ortsvektors zu x auf v
s = (v*x')/norm(v);

% bestimme die vektorielle Projektion des Ortsvektors zu x auf v
w = (s/norm(v))*v;

% bestimme Projektionsvektor p von x auf die Ebene
p = x-w;

% bestimme den Abstand von x zum Projektionsvektor p
d = norm(x-p);

% gebe den Projektionsvektor sowie den Abstand aus
str1=['Projektionsvektor = ' num2str(p)];
disp(str1);
str2=['Abstand = ' num2str(d)];
disp(str2);