param n;                                     # number of brick companies
param m;                                     # number of construction sites

param Z{i in 1..n};                          # capacity
param B{j in 1..m};                          # demand

param d{i in 1..n, j in 1..m};               # distances

var x{i in 1..n, j in 1..m} >= 0 integer;    # number of bricks to transport

minimize cost: sum{i in 1..n, j in 1..m} d[i,j]*x[i,j];

subject to capacity{i in 1..n}: sum{j in 1..m} x[i,j] <= Z[i];

subject to demand{j in 1..m}: sum{i in 1..n} x[i,j] >= B[j];