param n;					# pattern size / count of numbers

set BOX{b in 1..n} dimen 2;			# defines boxes

set FIX dimen 3;				# contains given numbers

var x{i in 1..n, j in 1..n, k in 1..n} binary;  # =1 <=> number k at position (i,j)

subject to row{i in 1..n, k in 1..n}:    sum{j in 1..n} x[i,j,k] = 1;
subject to column{j in 1..n, k in 1..n}: sum{i in 1..n} x[i,j,k] = 1;
subject to box{b in 1..n, k in 1..n}:    sum{(i,j) in BOX[b]} x[i,j,k] = 1;
subject to cell{i in 1..n, j in 1..n}:   sum{k in 1..n} x[i,j,k] = 1;

subject to fix{(i,j,k) in FIX}: x[i,j,k] = 1;