param n;					
param m;

set S := 1 .. n;
set SS := 1 .. 2**n - 2;
set POW {k in SS} := {i in S: (k div 2**(i-1)) mod 2 = 1};

var x{i in 1..n, j in 1..n, k in 1..m} binary;

maximize cycles:sum{i in 1..n,j in 1..n,k in 1..m} x[i,j,k];

subject to degree{i in 1..n, k in 1..m}: sum{j in 1..n} x[i,j,k] >= 2;
subject to subtour_elimination{l in SS, k in 1..m}: sum{i in POW[l], j in POW[l]} x[i,j,k] <= 2*card(POW[l])-2;
subject to disjoint{i in 1..n, j in 1..n}: sum{k in 1..m} x[i,j,k] <= 1;
subject to symmetry{i in 1..n, j in 1..n, k in 1..m}: x[i,j,k]=x[j,i,k];