function [f,g,h]=rosenbrock(x,donotplot)
% [f,g,h]=rosenbrock(x) with x in R^2

  global fun_cnt;
if (nargin<1)
  display(' Rosenbrock: no input argument!');
  x=[1,1];
end;
if(nargin<2)
  donotplot=0;
end

if (length(x)~=2)
  disp('Rosenbrock: input argument must be in R^2');
  x=[1,1];
end;

x1=x(1);
y1=x(2);

g=[2*x1-2-400*(y1-x1^2)*x1;200*(y1-x1^2)];
h=[2+1200*x1^2-400*y1, -400*x1;-400*x1,200];
f=[100*(y1-x1^2)^2+(1-x1)^2];

if (donotplot==0)
  plot([x1],[y1],'or');
  fun_cnt=fun_cnt+1;
disp(['evaluation ' num2str(fun_cnt) '  norm(point)=' num2str(norm(x)) '      [press any key]' ]); 
  pause;
end

